/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kudu.config.KuduSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduOutputFormat
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(KuduOutputFormat.class);
    public static final long TIMEOUTMS = 18000L;
    public static final long SESSIONTIMEOUTMS = 100000L;
    private final String kuduMaster;
    private final String kuduTableName;
    private final KuduSinkConfig.SaveMode saveMode;
    private KuduClient kuduClient;
    private KuduSession kuduSession;
    private KuduTable kuduTable;

    public KuduOutputFormat(KuduSinkConfig kuduSinkConfig) {
        this.kuduMaster = kuduSinkConfig.getKuduMaster();
        this.kuduTableName = kuduSinkConfig.getKuduTableName();
        this.saveMode = kuduSinkConfig.getSaveMode();
        this.init();
    }

    private void transform(PartialRow row, SeaTunnelRow element, Schema schema) {
        int columnCount = schema.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            ColumnSchema col = schema.getColumnByIndex(columnIndex);
            try {
                switch (col.getType()) {
                    case BOOL: {
                        row.addBoolean(columnIndex, (boolean)((Boolean)element.getField(columnIndex)));
                        break;
                    }
                    case INT8: {
                        row.addByte(columnIndex, (byte)((Byte)element.getField(columnIndex)));
                        break;
                    }
                    case INT16: {
                        row.addShort(columnIndex, (short)((Short)element.getField(columnIndex)));
                        break;
                    }
                    case INT32: {
                        row.addInt(columnIndex, (int)((Integer)element.getField(columnIndex)));
                        break;
                    }
                    case INT64: {
                        row.addLong(columnIndex, (long)((Long)element.getField(columnIndex)));
                        break;
                    }
                    case UNIXTIME_MICROS: {
                        if (element.getField(columnIndex) instanceof Timestamp) {
                            row.addTimestamp(columnIndex, (Timestamp)element.getField(columnIndex));
                            break;
                        }
                        row.addLong(columnIndex, (long)((Long)element.getField(columnIndex)));
                        break;
                    }
                    case FLOAT: {
                        row.addFloat(columnIndex, ((Float)element.getField(columnIndex)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        row.addDouble(columnIndex, (double)((Double)element.getField(columnIndex)));
                        break;
                    }
                    case STRING: {
                        row.addString(columnIndex, element.getField(columnIndex).toString());
                        break;
                    }
                    case BINARY: {
                        if (element.getField(columnIndex) instanceof byte[]) {
                            row.addBinary(columnIndex, (byte[])element.getField(columnIndex));
                            break;
                        }
                        row.addBinary(columnIndex, (ByteBuffer)element.getField(columnIndex));
                        break;
                    }
                    case DECIMAL: {
                        row.addDecimal(columnIndex, (BigDecimal)element.getField(columnIndex));
                        break;
                    }
                    default: {
                        throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported column type: " + (Object)((Object)col.getType()));
                    }
                }
                continue;
            }
            catch (ClassCastException e) {
                throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.DATA_TYPE_CAST_FILED, "Value type does not match column type " + (Object)((Object)col.getType()) + " for column " + col.getName());
            }
        }
    }

    private void upsert(SeaTunnelRow element) {
        Upsert upsert = this.kuduTable.newUpsert();
        Schema schema = this.kuduTable.getSchema();
        PartialRow row = upsert.getRow();
        this.transform(row, element, schema);
        try {
            this.kuduSession.apply(upsert);
        }
        catch (KuduException e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.KUDU_UPSERT_FAILED, (Throwable)e);
        }
    }

    private void insert(SeaTunnelRow element) {
        Insert insert = this.kuduTable.newInsert();
        Schema schema = this.kuduTable.getSchema();
        PartialRow row = insert.getRow();
        this.transform(row, element, schema);
        try {
            this.kuduSession.apply(insert);
        }
        catch (KuduException e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.KUDU_INSERT_FAILED, (Throwable)e);
        }
    }

    public void write(SeaTunnelRow element) {
        switch (this.saveMode) {
            case APPEND: {
                this.insert(element);
                break;
            }
            case OVERWRITE: {
                this.upsert(element);
                break;
            }
            default: {
                throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.FLUSH_DATA_FAILED, String.format("Unsupported saveMode: %s.", this.saveMode.name()));
            }
        }
    }

    private void init() {
        KuduClient.KuduClientBuilder kuduClientBuilder = new KuduClient.KuduClientBuilder(this.kuduMaster);
        kuduClientBuilder.defaultOperationTimeoutMs(18000L);
        this.kuduClient = kuduClientBuilder.build();
        this.kuduSession = this.kuduClient.newSession();
        this.kuduSession.setTimeoutMillis(100000L);
        this.kuduSession.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        try {
            this.kuduTable = this.kuduClient.openTable(this.kuduTableName);
        }
        catch (KuduException e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.INIT_KUDU_CLIENT_FAILED, (Throwable)e);
        }
        log.info("The Kudu client for Master: {} is initialized successfully.", (Object)this.kuduMaster);
    }

    public void closeOutputFormat() {
        if (this.kuduClient != null) {
            try {
                this.kuduClient.close();
                this.kuduSession.close();
            }
            catch (KuduException ignored) {
                log.warn("Failed to close Kudu Client.", (Throwable)ignored);
            }
            finally {
                this.kuduClient = null;
                this.kuduSession = null;
            }
        }
    }
}

