/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient;

import java.sql.SQLException;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTypeMapper.class);
    private static final String KUDU_UNKNOWN = "UNKNOWN";
    private static final String KUDU_BIT = "BOOL";
    private static final String KUDU_TINYINT = "INT8";
    private static final String KUDU_MEDIUMINT = "INT32";
    private static final String KUDU_INT = "INT16";
    private static final String KUDU_BIGINT = "INT64";
    private static final String KUDU_FLOAT = "FLOAT";
    private static final String KUDU_DOUBLE = "DOUBLE";
    private static final String KUDU_DECIMAL = "DECIMAL32";
    private static final String KUDU_VARCHAR = "STRING";
    private static final String KUDU_UNIXTIME_MICROS = "UNIXTIME_MICROS";
    private static final String KUDU_BINARY = "BINARY";
    private static final int PRECISION = 20;

    public static SeaTunnelDataType<?> mapping(List<ColumnSchema> columnSchemaList, int colIndex) throws SQLException {
        String kuduType;
        switch (kuduType = columnSchemaList.get(colIndex).getType().getName().toUpperCase()) {
            case "BOOL": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "INT8": 
            case "INT32": 
            case "INT16": {
                return BasicType.INT_TYPE;
            }
            case "INT64": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL32": {
                return new DecimalType(20, 0);
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "STRING": {
                return BasicType.STRING_TYPE;
            }
            case "UNIXTIME_MICROS": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "BINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support KUDU type '%s' .", kuduType));
    }
}

