/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.sink;

import java.io.IOException;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.kudu.config.KuduSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient.KuduOutputFormat;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(KuduSinkWriter.class);
    private SeaTunnelRowType seaTunnelRowType;
    private Config pluginConfig;
    private KuduOutputFormat fileWriter;
    private KuduSinkConfig kuduSinkConfig;

    public KuduSinkWriter(@NonNull SeaTunnelRowType seaTunnelRowType, @NonNull Config pluginConfig) {
        if (seaTunnelRowType == null) {
            throw new NullPointerException("seaTunnelRowType is marked non-null but is null");
        }
        if (pluginConfig == null) {
            throw new NullPointerException("pluginConfig is marked non-null but is null");
        }
        this.seaTunnelRowType = seaTunnelRowType;
        this.pluginConfig = pluginConfig;
        this.kuduSinkConfig = new KuduSinkConfig(this.pluginConfig);
        this.fileWriter = new KuduOutputFormat(this.kuduSinkConfig);
    }

    public void write(SeaTunnelRow element) throws IOException {
        this.fileWriter.write(element);
    }

    public void close() throws IOException {
        this.fileWriter.closeOutputFormat();
    }
}

