/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.source;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient.KuduInputFormat;
import org.apache.seatunnel.connectors.seatunnel.kudu.source.KuduSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduSourceReader
implements SourceReader<SeaTunnelRow, KuduSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(KuduSourceReader.class);
    private final SourceReader.Context context;
    private final KuduInputFormat kuduInputFormat;
    Deque<KuduSourceSplit> splits = new LinkedList<KuduSourceSplit>();
    boolean noMoreSplit;

    public KuduSourceReader(KuduInputFormat kuduInputFormat, SourceReader.Context context) {
        this.context = context;
        this.kuduInputFormat = kuduInputFormat;
    }

    public void open() {
        this.kuduInputFormat.openInputFormat();
    }

    public void close() {
        this.kuduInputFormat.closeInputFormat();
    }

    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        KuduSourceSplit split2 = this.splits.poll();
        Object[] parameterValues = split2.parameterValues;
        int lowerBound = Integer.parseInt(parameterValues[0].toString());
        int upperBound = Integer.parseInt(parameterValues[1].toString());
        List<ColumnSchema> columnSchemaList = this.kuduInputFormat.getColumnsSchemas();
        KuduScanner kuduScanner = this.kuduInputFormat.getKuduBuildSplit(lowerBound, upperBound);
        while (kuduScanner.hasMoreRows()) {
            RowResultIterator rowResults = kuduScanner.nextRows();
            while (rowResults.hasNext()) {
                RowResult rowResult = rowResults.next();
                SeaTunnelRow seaTunnelRow = KuduInputFormat.getSeaTunnelRowData(rowResult, this.kuduInputFormat.getSeaTunnelRowType(columnSchemaList));
                output.collect((Object)seaTunnelRow);
            }
        }
        if (Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
            log.info("Closed the bounded fake source");
            this.context.signalNoMoreElement();
        }
    }

    public List<KuduSourceSplit> snapshotState(long checkpointId) {
        return Collections.emptyList();
    }

    public void addSplits(List<KuduSourceSplit> splits) {
        this.splits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }
}

