/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.kudu.source.KuduSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.kudu.source.PartitionParameter;
import org.apache.seatunnel.connectors.seatunnel.kudu.state.KuduSourceState;

public class KuduSourceSplitEnumerator
implements SourceSplitEnumerator<KuduSourceSplit, KuduSourceState> {
    private final SourceSplitEnumerator.Context<KuduSourceSplit> enumeratorContext;
    private PartitionParameter partitionParameter;
    List<KuduSourceSplit> allSplit = new ArrayList<KuduSourceSplit>();
    private Long maxVal;
    private Long minVal;
    private Long batchSize;
    private Integer batchNum;

    public KuduSourceSplitEnumerator(SourceSplitEnumerator.Context<KuduSourceSplit> enumeratorContext, PartitionParameter partitionParameter) {
        this.enumeratorContext = enumeratorContext;
        this.partitionParameter = partitionParameter;
    }

    public void open() {
    }

    public void run() {
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<KuduSourceSplit> splits, int subtaskId) {
    }

    public int currentUnassignedSplitSize() {
        return 0;
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
        int parallelism = this.enumeratorContext.currentParallelism();
        if (this.allSplit.isEmpty()) {
            if (null != this.partitionParameter) {
                Serializable[][] parameterValues = this.getParameterValues(this.partitionParameter.minValue, this.partitionParameter.maxValue, parallelism);
                for (int i = 0; i < parameterValues.length; ++i) {
                    this.allSplit.add(new KuduSourceSplit(parameterValues[i], i));
                }
            } else {
                this.allSplit.add(new KuduSourceSplit(null, 0));
            }
        }
        List splits = this.allSplit.stream().filter(p -> p.splitId % parallelism == subtaskId).collect(Collectors.toList());
        this.enumeratorContext.assignSplit(subtaskId, splits);
        this.enumeratorContext.signalNoMoreSplits(subtaskId);
    }

    private Serializable[][] getParameterValues(Long minVal, Long maxVal, int parallelism) {
        this.maxVal = maxVal;
        this.minVal = minVal;
        long maxElemCount = maxVal - minVal + 1L;
        this.batchNum = parallelism;
        this.getBatchSizeAndBatchNum(parallelism);
        long bigBatchNum = maxElemCount - (this.batchSize - 1L) * (long)this.batchNum.intValue();
        Serializable[][] parameters = new Serializable[this.batchNum.intValue()][2];
        long start = minVal;
        for (int i = 0; i < this.batchNum; ++i) {
            long end = start + this.batchSize - 1L - (long)((long)i >= bigBatchNum ? 1 : 0);
            parameters[i] = new Long[]{start, end};
            start = end + 1L;
        }
        return parameters;
    }

    private void getBatchSizeAndBatchNum(int parallelism) {
        this.batchNum = parallelism;
        long maxElemCount = this.maxVal - this.minVal + 1L;
        if ((long)this.batchNum.intValue() > maxElemCount) {
            this.batchNum = (int)maxElemCount;
        }
        this.batchNum = this.batchNum;
        this.batchSize = new Double(Math.ceil((double)maxElemCount / (double)this.batchNum.intValue())).longValue();
    }

    public KuduSourceState snapshotState(long checkpointId) throws Exception {
        return null;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

