/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Project
extends LazyLoad {
    private ProjectModel model;
    private RestClient client;
    private HashMap<String, String> properties = new HashMap();
    private HashMap<String, String> allProperties;
    private SecurityManager securityManager = null;
    private Clusters clusters;

    Project(ProjectModel model, RestClient client) {
        this.model = model;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        try {
            this.model = JAXBUtils.unmarshal(resp, ProjectModel.class);
            Map<String, String> headers = resp.getHeaders();
            this.model.owner = headers.get("x-odps-owner");
            this.model.creationTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.lastModified = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
            this.properties = this.model.properties;
            this.clusters = this.model.clusters;
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + ProjectModel.class, e);
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    void setComment(String comment) {
        this.model.comment = comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.creationTime == null) {
            this.lazyLoad();
        }
        return this.model.creationTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModified == null) {
            this.lazyLoad();
        }
        return this.model.lastModified;
    }

    String getProjectGroupName() {
        this.lazyLoad();
        return this.model.projectGroupName;
    }

    public Status getStatus() {
        if (this.model.state == null) {
            this.lazyLoad();
        }
        Status status = null;
        try {
            status = Status.valueOf(this.model.state.toUpperCase());
        }
        catch (Exception e) {
            return Status.UNKOWN;
        }
        return status;
    }

    public Map<String, String> getProperties() {
        this.lazyLoad();
        return this.properties;
    }

    public Map<String, String> getAllProperties() throws OdpsException {
        if (this.allProperties == null) {
            String resource = ResourceBuilder.buildProjectResource(this.model.name);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("properties", "all");
            Response resp = this.client.request(resource, "GET", params, null, null);
            try {
                ProjectModel model = JAXBUtils.unmarshal(resp, ProjectModel.class);
                this.allProperties = model.properties;
            }
            catch (Exception e) {
                throw new OdpsException("Can't bind xml to " + ProjectModel.class, e);
            }
        }
        return this.allProperties;
    }

    List<Cluster> getClusters() {
        this.lazyLoad();
        return this.clusters == null ? null : this.clusters.entries;
    }

    public String getProperty(String key) {
        this.lazyLoad();
        return this.properties == null ? null : this.properties.get(key);
    }

    public Map<String, String> getExtendedProperties() throws OdpsException {
        HashMap<String, String> param2 = new HashMap<String, String>();
        param2.put("extended", null);
        String resource = ResourceBuilder.buildProjectResource(this.model.name);
        ProjectModel extendedModel = this.client.request(ProjectModel.class, resource, "GET", param2);
        return extendedModel.extendedProperties;
    }

    public SecurityManager getSecurityManager() {
        if (this.securityManager == null) {
            this.securityManager = new SecurityManager(this.model.name, this.client);
        }
        return this.securityManager;
    }

    public String getTunnelEndpoint() throws OdpsException {
        String protocol;
        try {
            URI u = new URI(this.client.getEndpoint());
            protocol = u.getScheme();
        }
        catch (URISyntaxException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        String resource = ResourceBuilder.buildProjectResource(this.model.name).concat("/tunnel");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", null);
        Response resp = this.client.request(resource, "GET", params, null, null);
        if (!resp.isOK()) {
            throw new OdpsException("Can't get tunnel server address: " + resp.getStatus());
        }
        String tunnel = new String(resp.getBody());
        return protocol + "://" + tunnel;
    }

    static class PropertyAdapter
    extends XmlAdapter<Properties, HashMap<String, String>> {
        PropertyAdapter() {
        }

        @Override
        public HashMap<String, String> unmarshal(Properties in) throws Exception {
            if (in == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Property entry : in.entries) {
                hashMap.put(entry.name, entry.value);
            }
            return hashMap;
        }

        @Override
        public Properties marshal(HashMap<String, String> map2) throws Exception {
            if (map2 == null) {
                return null;
            }
            Properties props = new Properties();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                props.entries.add(new Property(entry.getKey(), entry.getValue()));
            }
            return props;
        }
    }

    static class Properties {
        @XmlElement(name="Property")
        List<Property> entries = new ArrayList<Property>();

        Properties() {
        }
    }

    static class Property {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Value")
        String value;

        Property() {
        }

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    static class Clusters {
        @XmlElement(name="Cluster")
        List<Cluster> entries = new ArrayList<Cluster>();

        Clusters() {
        }
    }

    public static class Cluster {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="QuotaID")
        String quotaID;

        Cluster() {
        }

        public Cluster(String name, String quotaID) {
            if (StringUtils.isNullOrEmpty(name) || StringUtils.isNullOrEmpty(quotaID)) {
                throw new IllegalArgumentException("Missing arguments: name, quotaID");
            }
            this.name = name;
            this.quotaID = quotaID;
        }

        public String getName() {
            return this.name;
        }

        public String getQuotaID() {
            return this.quotaID;
        }
    }

    @XmlRootElement(name="Project")
    static class ProjectModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Comment")
        String comment;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date creationTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date lastModified;
        @XmlElement(name="ProjectGroupName")
        String projectGroupName;
        @XmlElement(name="Properties")
        @XmlJavaTypeAdapter(value=PropertyAdapter.class)
        HashMap<String, String> properties;
        @XmlElement(name="ExtendedProperties")
        @XmlJavaTypeAdapter(value=PropertyAdapter.class)
        HashMap<String, String> extendedProperties;
        @XmlElement(name="State")
        String state;
        @XmlElement(name="Clusters")
        Clusters clusters;

        ProjectModel() {
        }
    }

    public static enum Status {
        AVAILABLE,
        READONLY,
        DELETING,
        FROZEN,
        UNKOWN;

    }
}

