/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Table;

public class TableResource
extends Resource {
    public TableResource() {
        this(null, null);
    }

    public TableResource(String tableName) {
        this(tableName, null);
    }

    public TableResource(String tableName, String projectName) {
        this(tableName, projectName, null);
    }

    public TableResource(String tableName, String projectName, PartitionSpec partition2) {
        this.model.sourceTableName = projectName != null ? projectName + "." + tableName : tableName;
        if (partition2 == null) {
            this.model.type = Resource.Type.TABLE.toString();
        } else {
            this.model.sourceTableName = this.model.sourceTableName + " partition(" + partition2.toString() + ")";
            this.model.type = Resource.Type.TABLE.toString();
        }
    }

    @Deprecated
    public TableResource(Resource resource) {
        super(resource.model, resource.project, resource.odps);
        if (this.model == null || !Resource.Type.TABLE.toString().equalsIgnoreCase(this.getType().toString())) {
            throw new IllegalArgumentException("Resource type is not TABLE");
        }
    }

    String getSourceTableName() {
        if (this.model.sourceTableName == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.sourceTableName;
    }

    public Table getSourceTable() {
        String src = this.getSourceTableName();
        if (src == null) {
            return null;
        }
        String[] res = src.split(" partition\\(");
        int off = (src = res[0]).indexOf(46);
        if (off == -1) {
            throw new IllegalArgumentException("Malformed source table name:" + src);
        }
        String projName = src.substring(0, off).trim();
        String tblName = src.substring(off + 1, src.length()).trim();
        Table.TableModel tm = new Table.TableModel();
        tm.name = tblName;
        return new Table(tm, projName, this.odps);
    }

    public PartitionSpec getSourceTablePartition() {
        String src = this.getSourceTableName();
        if (src == null) {
            return null;
        }
        String[] res = src.split(" partition\\(");
        if (res.length < 2) {
            return null;
        }
        String partition2 = res[1];
        int lastindex = partition2.lastIndexOf(41);
        if (lastindex >= 0) {
            partition2 = partition2.substring(0, lastindex);
        }
        return new PartitionSpec(partition2.trim());
    }
}

