/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.XFlow;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

public class XFlows
implements Iterable<XFlow> {
    private Odps odps;
    private static final String CHARSET = "utf-8";

    XFlows(Odps odps) {
        this.odps = odps;
    }

    public XFlow get(String name) {
        return this.get(name, this.getDefaultProjectName());
    }

    public XFlow get(String name, String projectName) {
        XFlow.XFlowModel model = new XFlow.XFlowModel();
        model.setName(name);
        return new XFlow(model, this.odps.getDefaultProject(), this.odps);
    }

    public boolean exists(String name) throws OdpsException {
        return this.exists(name, this.getDefaultProjectName());
    }

    public boolean exists(String name, String projectName) throws OdpsException {
        try {
            XFlow xFlow = this.get(name);
            xFlow.reload();
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    public ListIterator<XFlow> iterator(final String projectName, final String owner) {
        return new ListIterator<XFlow>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<XFlow> list() {
                ArrayList<XFlow> xFlows = new ArrayList<XFlow>();
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (owner != null) {
                    this.params.put("owner", owner);
                }
                String resource = ResourceBuilder.buildXFlowsResource(projectName);
                try {
                    ListXFlowsResponse resp = XFlows.this.odps.getRestClient().request(ListXFlowsResponse.class, resource, "GET", this.params);
                    for (XFlow.XFlowModel model : resp.xFlows) {
                        XFlow t = new XFlow(model, projectName, XFlows.this.odps);
                        xFlows.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return xFlows;
            }
        };
    }

    public void create(XFlow.XFlowModel model) throws OdpsException {
        this.create(model, this.getDefaultProjectName());
    }

    public void create(XFlow.XFlowModel model, String projectName) throws OdpsException {
        String resoure = ResourceBuilder.buildXFlowsResource(projectName);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.odps.getRestClient().stringRequest(resoure, "POST", null, headers, model.getXmlSource());
    }

    public void delete(String name) throws OdpsException {
        this.delete(name, this.getDefaultProjectName());
    }

    public void delete(String name, String projectName) throws OdpsException {
        String resoure = ResourceBuilder.buildXFlowResource(projectName, name);
        this.odps.getRestClient().request(resoure, "DELETE", null, null, null);
    }

    public void update(XFlow.XFlowModel model) throws OdpsException {
        this.update(model, this.getDefaultProjectName());
    }

    public void update(XFlow.XFlowModel model, String projectName) throws OdpsException {
        String resoure = ResourceBuilder.buildXFlowResource(projectName, model.name);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.odps.getRestClient().stringRequest(resoure, "PUT", null, headers, model.getXmlSource());
    }

    private String getDefaultProjectName() {
        String project = this.odps.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @Override
    public Iterator<XFlow> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<XFlow> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Instance execute(XFlowInstance xFlowInstance) throws OdpsException {
        return this.execute(xFlowInstance, this.getDefaultProjectName());
    }

    public Instance execute(XFlowInstance xFlowInstance, String project) throws OdpsException {
        String xml = null;
        if (project == null) {
            throw new IllegalArgumentException("project required.");
        }
        if (xFlowInstance == null) {
            throw new IllegalArgumentException("Job required.");
        }
        AnnoymousXFlowInstance i = new AnnoymousXFlowInstance();
        i.xFlowInstance = xFlowInstance;
        try {
            xml = JAXBUtils.marshal(i, AnnoymousXFlowInstance.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ResourceBuilder.buildInstancesResource(project);
        Response resp = this.odps.getRestClient().stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        String instanceId = location.substring(location.lastIndexOf("/") + 1);
        HashMap<String, Instance.Result> results = new HashMap<String, Instance.Result>();
        if (resp.getStatus() == 200 && resp.getBody() != null && resp.getBody().length > 0) {
            try {
                Instance.InstanceResultModel result2 = JAXBUtils.unmarshal(resp, Instance.InstanceResultModel.class);
                for (Instance.InstanceResultModel.TaskResult r : result2.taskResults) {
                    results.put(r.name, r.result);
                }
            }
            catch (JAXBException e) {
                throw new OdpsException("Invalid create instance response.", e);
            }
        }
        Instance.TaskStatusModel model = new Instance.TaskStatusModel();
        model.name = instanceId;
        Instance instance = new Instance(this.getDefaultProjectName(), model, results, this.odps);
        return instance;
    }

    public Map<String, XResult> getXResults(Instance xInstance) throws OdpsException {
        String uri = ResourceBuilder.buildInstanceResource(xInstance.getProject(), xInstance.getId());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("xresult", null);
        XFlowResult xFlowResult = this.odps.getRestClient().request(XFlowResult.class, uri, "GET", params, null, null);
        HashMap<String, XResult> result2 = new HashMap<String, XResult>();
        for (XResult i : xFlowResult.getXResults()) {
            result2.put(i.getName(), i);
        }
        return result2;
    }

    public String getXSource(Instance xInstance) throws OdpsException {
        String resource = ResourceBuilder.buildInstanceResource(xInstance.getProject(), xInstance.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("xsource", null);
        Response response = this.odps.getRestClient().request(resource, "GET", params, null, null);
        try {
            return new String(response.getBody(), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public XFlowInstance getXFlowInstance(Instance instance) throws OdpsException {
        try {
            AnnoymousXFlowInstance annoymousXFlowInstance = JAXBUtils.unmarshal(this.getXSource(instance).getBytes(), AnnoymousXFlowInstance.class);
            return annoymousXFlowInstance.xFlowInstance;
        }
        catch (JAXBException e) {
            throw new OdpsException("Invalid create XFlow instance response.", e);
        }
    }

    public boolean isXFlowInstance(Instance instance) {
        try {
            this.getXFlowInstance(instance);
            return true;
        }
        catch (OdpsException e) {
            return false;
        }
    }

    @XmlRootElement(name="Xinstance")
    private static class XFlowResult {
        @XmlElementWrapper(name="Actions")
        @XmlElement(name="Action")
        private Set<XResult> xresults = new LinkedHashSet<XResult>();

        private XFlowResult() {
        }

        public Set<XResult> getXResults() {
            return this.xresults;
        }
    }

    public static class XResult {
        @XmlAttribute(name="NodeType")
        String nodeType;
        @XmlElement(name="InstanceId")
        String instanceId;
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Result")
        Instance.Result result;

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getName() {
            return this.name;
        }

        public String getResult() {
            return this.result.getString();
        }

        public String getNodeType() {
            return this.nodeType;
        }
    }

    @XmlRootElement(name="XflowInstance")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"RunningMode", "project", "XflowName", "parameters", "guid", "priority", "config"})
    public static class XFlowInstance {
        @XmlElement(name="Xflow")
        private String XflowName;
        @XmlElement(name="RunningMode")
        private String RunningMode;
        @XmlElement(name="Project")
        private String project;
        @XmlElement(name="Parameters")
        private Parameters parameters = new Parameters();
        @XmlElement(name="Guid")
        private String guid;
        @XmlElement(name="Priority")
        private int priority = 1;
        @XmlElement(name="Config")
        private Config config = new Config();

        public String getXflowName() {
            return this.XflowName;
        }

        public void setXflowName(String xflowName) {
            this.XflowName = xflowName;
        }

        public String getRunningMode() {
            return this.RunningMode;
        }

        public void setRunningMode(String runningMode) {
            this.RunningMode = runningMode;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        @XmlTransient
        public final void setParameters(Map<String, String> parameters) {
            this.parameters = new Parameters();
            for (Map.Entry<String, String> p : parameters.entrySet()) {
                this.setParameter(p.getKey(), p.getValue());
            }
        }

        public void setParameter(String key, String value) {
            Parameter p = new Parameter();
            p.key = key;
            p.value = value;
            this.parameters.parameters.add(p);
        }

        public String getGuid() {
            return this.guid;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public Config getConfig() {
            return this.config;
        }

        @XmlTransient
        public final void setConfig(Map<String, String> config) {
            this.config = new Config();
            for (Map.Entry<String, String> p : config.entrySet()) {
                this.setProperty(p.getKey(), p.getValue());
            }
        }

        public void setProperty(String name, String value) {
            Property p = new Property();
            p.setName(name);
            p.setValue(value);
            this.config.config.add(p);
        }

        @XmlRootElement(name="Parameters")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        static class Parameters {
            @XmlElement(name="Parameter")
            Set<Parameter> parameters = new LinkedHashSet<Parameter>();

            Parameters() {
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"key", "value"})
        public static class Parameter {
            @XmlElement(name="Key", required=true)
            private String key;
            @XmlElement(name="Value", required=true)
            private String value;

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        @XmlRootElement(name="Config")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        static class Config {
            @XmlElement(name="Property")
            Set<Property> config = new LinkedHashSet<Property>();

            Config() {
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"name", "value"})
        public static class Property {
            @XmlElement(name="Name", required=true)
            private String name;
            @XmlElement(name="Value", required=true)
            private String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    @XmlRootElement(name="Instance")
    static class AnnoymousXFlowInstance {
        @XmlElement(name="XflowInstance")
        XFlowInstance xFlowInstance;

        AnnoymousXFlowInstance() {
        }
    }

    @XmlRootElement(name="xflows")
    private static class ListXFlowsResponse {
        @XmlElement(name="xflow")
        private List<XFlow.XFlowModel> xFlows = new ArrayList<XFlow.XFlowModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListXFlowsResponse() {
        }
    }
}

