/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.RestClient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Role
extends LazyLoad {
    private RoleModel model;
    private String project;
    private RestClient client;

    Role(RoleModel model, String project, RestClient client) {
        this.model = model;
        this.project = project;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/roles/").append(this.model.name);
        this.model = this.client.request(RoleModel.class, resource.toString(), "GET");
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        this.lazyLoad();
        return this.model.comment;
    }

    @XmlRootElement(name="Role")
    static class RoleModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Comment")
        String comment;

        RoleModel() {
        }
    }
}

