/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class RawTunnelRecordReader
extends ProtobufRecordStreamReader {
    private Connection conn;

    public RawTunnelRecordReader(TableSchema schema, List<Column> columns, Connection conn, CompressOption option) throws IOException {
        super(schema, columns, conn.getInputStream(), option);
        this.conn = conn;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.conn.disconnect();
    }

    public static RawTunnelRecordReader createInstanceTunnelReader(long start, long count2, CompressOption compress, List<Column> columns, RestClient restClient, InstanceTunnel.DownloadSession session) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        switch (compress.algorithm) {
            case ODPS_RAW: {
                break;
            }
            case ODPS_ZLIB: {
                headers.put("Accept-Encoding", "deflate");
                break;
            }
            case ODPS_SNAPPY: {
                headers.put("Accept-Encoding", "x-snappy-framed");
                break;
            }
            default: {
                throw new TunnelException("invalid compression option.");
            }
        }
        if (columns != null && columns.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.size(); ++i) {
                sb.append(columns.get(i).getName());
                if (i == columns.size() - 1) continue;
                sb.append(",");
            }
            params.put("columns", sb.toString());
        }
        params.put("downloadid", session.getId());
        params.put("data", null);
        params.put("rowrange", "(" + start + "," + count2 + ")");
        Object reader = null;
        Connection conn = null;
        try {
            conn = restClient.connect(ResourceBuilder.buildInstanceResource(session.getProjectName(), session.getInstanceID()), "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(conn.getInputStream());
                err.setRequestId(resp.getHeader("x-odps-request-id"));
                throw err;
            }
            CompressOption option = null;
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (content_encoding.equals("deflate")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0);
                } else if (content_encoding.equals("x-snappy-framed")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_SNAPPY, -1, 0);
                } else {
                    throw new TunnelException("invalid content encoding");
                }
            }
            return new RawTunnelRecordReader(session.getSchema(), columns, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public static RawTunnelRecordReader createTableTunnelReader(long start, long count2, CompressOption compress, List<Column> columns, RestClient restClient, TableTunnel.DownloadSession session) throws IOException, TunnelException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        if (compress != null) {
            switch (compress.algorithm) {
                case ODPS_RAW: {
                    break;
                }
                case ODPS_ZLIB: {
                    headers.put("Accept-Encoding", "deflate");
                    break;
                }
                case ODPS_SNAPPY: {
                    headers.put("Accept-Encoding", "x-snappy-framed");
                    break;
                }
                default: {
                    throw new TunnelException("invalid compression option.");
                }
            }
        }
        if (columns != null && columns.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.size(); ++i) {
                sb.append(columns.get(i).getName());
                if (i == columns.size() - 1) continue;
                sb.append(",");
            }
            params.put("columns", sb.toString());
        }
        params.put("downloadid", session.getId());
        params.put("data", null);
        params.put("rowrange", "(" + start + "," + count2 + ")");
        String partitionSpec = session.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.length() > 0) {
            params.put("partition", partitionSpec);
        }
        Connection conn = null;
        try {
            conn = restClient.connect(ResourceBuilder.buildTableResource(session.getProjectName(), session.getTableName()), "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(conn.getInputStream());
                err.setRequestId(resp.getHeader("x-odps-request-id"));
                throw err;
            }
            CompressOption option = null;
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (content_encoding.equals("deflate")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0);
                } else if (content_encoding.equals("x-snappy-framed")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_SNAPPY, -1, 0);
                } else {
                    throw new TunnelException("invalid content encoding");
                }
            }
            return new RawTunnelRecordReader(session.getSchema(), columns, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
    }
}

