/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.RawTunnelRecordReader;
import java.io.IOException;
import java.util.List;

public class TunnelRecordReader
extends ProtobufRecordStreamReader {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30;
    public static final int DEFAULT_CONNECT_RETRYTIMES = 4;
    private int retryTimes = 4;
    private int retryCount = 0;
    private long start = 0L;
    private long count = 0L;
    private long offset = 0L;
    private long bytesReaded = 0L;
    private boolean isClosed = false;
    private List<Column> columnList;
    private CompressOption option;
    private RestClient tunnelServiceClient;
    private TableTunnel.DownloadSession tableSession;
    private InstanceTunnel.DownloadSession instanceSession;
    private RawTunnelRecordReader reader;

    @Deprecated
    public TunnelRecordReader(TableSchema schema, Connection conn, CompressOption option) throws IOException {
        super(schema, conn.getInputStream(), option);
    }

    @Deprecated
    public TunnelRecordReader(TableSchema schema, List<Column> columns, Connection conn, CompressOption option) throws IOException {
        super(schema, columns, conn.getInputStream(), option);
    }

    public TunnelRecordReader(long start, long count2, List<Column> columns, CompressOption option, RestClient tunnelRestClient, TableTunnel.DownloadSession session) throws TunnelException, IOException {
        this.start = start;
        this.count = count2;
        this.offset = 0L;
        this.option = option;
        this.columnList = columns;
        this.tableSession = session;
        this.reader = null;
        this.instanceSession = null;
        this.tunnelServiceClient = tunnelRestClient;
        this.createNewReader();
    }

    @Override
    public void setTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
        this.reader.setTransform(shouldTransform);
    }

    public TunnelRecordReader(long start, long count2, List<Column> columns, CompressOption option, RestClient tunnelRestClient, InstanceTunnel.DownloadSession session) throws TunnelException, IOException {
        this.start = start;
        this.count = count2;
        this.offset = 0L;
        this.option = option;
        this.columnList = columns;
        this.tableSession = null;
        this.instanceSession = session;
        this.reader = null;
        this.tunnelServiceClient = tunnelRestClient;
        this.createNewReader();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
        this.isClosed = true;
    }

    @Override
    public Record read() throws IOException {
        return this.read(null);
    }

    @Override
    public Record read(Record reusedRecord) throws IOException {
        if (this.isClosed) {
            throw new IOException("Reader has been closed");
        }
        try {
            return this.readWithRetry(reusedRecord);
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getTotalBytes() {
        return this.bytesReaded + this.reader.getTotalBytes();
    }

    private Record readWithRetry(Record reusedRecord) throws TunnelException, IOException {
        try {
            Record record = this.reader.read(reusedRecord);
            ++this.offset;
            return record;
        }
        catch (IOException e) {
            if (++this.retryCount > this.retryTimes || this.offset > this.count) {
                throw e;
            }
            this.createNewReader();
            return this.readWithRetry(reusedRecord);
        }
    }

    private void createNewReader() throws TunnelException, IOException {
        while (this.retryCount <= this.retryTimes) {
            try {
                if (this.reader != null) {
                    this.bytesReaded += this.reader.getTotalBytes();
                    this.reader.close();
                }
                if (this.tableSession != null) {
                    this.reader = RawTunnelRecordReader.createTableTunnelReader(this.start + this.offset, this.count - this.offset, this.option, this.columnList, this.tunnelServiceClient, this.tableSession);
                    this.reader.setTransform(this.shouldTransform);
                }
                if (this.instanceSession != null) {
                    this.reader = RawTunnelRecordReader.createInstanceTunnelReader(this.start + this.offset, this.count - this.offset, this.option, this.columnList, this.tunnelServiceClient, this.instanceSession);
                    this.reader.setTransform(this.shouldTransform);
                }
                return;
            }
            catch (TunnelException e) {
                if (++this.retryCount == this.retryTimes) {
                    throw e;
                }
                this.sleep(30L);
            }
            catch (IOException e) {
                if (++this.retryCount == this.retryTimes) {
                    throw e;
                }
                this.sleep(30L);
            }
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

