/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamWriter;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;

public class TunnelRecordWriter
extends ProtobufRecordStreamWriter {
    private Connection conn;
    private boolean isClosed;

    public TunnelRecordWriter(TableSchema schema, Connection conn) throws IOException {
        this(schema, conn, null);
    }

    public TunnelRecordWriter(TableSchema schema, Connection conn, CompressOption option) throws IOException {
        super(schema, conn.getOutputStream(), option);
        this.conn = conn;
        this.isClosed = false;
    }

    @Override
    public void write(Record r) throws IOException {
        block3: {
            if (this.isClosed) {
                throw new IOException("Writer has been closed.");
            }
            try {
                super.write(r);
            }
            catch (IOException e) {
                Response resp = this.conn.getResponse();
                if (resp.isOK()) break block3;
                TunnelException err = new TunnelException(resp.getHeader("x-odps-request-id"), this.conn.getInputStream(), resp.getStatus());
                throw new IOException(err.getMessage(), err);
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            Response resp = this.conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(resp.getHeader("x-odps-request-id"), this.conn.getInputStream(), resp.getStatus());
                throw new IOException(err.getMessage(), err);
            }
        }
        finally {
            this.conn.disconnect();
            this.isClosed = true;
        }
    }
}

