/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

public class VolumeInputStream
extends InputStream {
    private Connection conn = null;
    private long totalBytes;
    private InputStream in;
    static final int CHECKSUM_SIZE = 4;
    private byte[] buffer;
    private int bufferSize;
    private int dataSize;
    private int pos;
    private boolean eof;
    private boolean init;
    private CRC32 crc = new CRC32();
    private int chunkSize;
    private final int MAX_CHUNKSIZE = 0x10000000;
    private final int MIN_CHUNKSIZE = 1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VolumeInputStream(Connection conn, CompressOption option) throws IOException {
        if (option != null) {
            if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) throw new IOException("invalid compression option.");
            this.in = new InflaterInputStream(conn.getInputStream());
        } else {
            this.in = conn.getInputStream();
        }
        this.conn = conn;
        this.pos = 0;
        this.eof = false;
        this.init = false;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.conn.disconnect();
    }

    int getInt(byte[] buffer, int offset) throws IOException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(buffer, offset, 4);
            bb.order(ByteOrder.BIG_ENDIAN);
            return bb.getInt();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf, 0, 1);
        if (len == 1) {
            return buf[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (!this.init) {
            this.init = true;
            byte[] intBuffer = new byte[4];
            int count2 = this.readInternal(intBuffer);
            if (count2 == 4) {
                this.crc.update(intBuffer, 0, 4);
                this.chunkSize = this.getInt(intBuffer, 0);
                if (this.chunkSize > 0x10000000 || this.chunkSize < 1) {
                    String errMsg = "ChunkSize should be in [1 ,268435456 ], now is : " + this.chunkSize;
                    throw new IOException(errMsg);
                }
                this.bufferSize = this.chunkSize + 4;
                this.buffer = new byte[this.bufferSize];
            } else if (count2 > 0) {
                throw new IOException("Invalid VolumeInputStream.");
            }
        }
        if (buf == null || buf.length == 0) {
            throw new IOException("Invalid Protobuf Data Buffer!");
        }
        int length = this.readBuffer(buf, off, len);
        if (length > 0) {
            this.totalBytes += (long)length;
            return length;
        }
        return -1;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int fillBuffer() throws IOException {
        if (this.dataSize > this.pos) {
            return 0;
        }
        int length = this.readInternal(this.buffer);
        if (length >= 4) {
            this.dataSize = length - 4;
            this.pos = 0;
            this.crc.update(this.buffer, 0, this.dataSize);
            int checksum = this.getInt(this.buffer, this.dataSize);
            if (checksum != (int)this.crc.getValue()) {
                throw new IOException("crc check error in VolumeInputStream. ");
            }
        } else if (length > 0) {
            throw new IOException("Invalid VolumeInputStream.");
        }
        return length;
    }

    public int readBuffer(byte[] buf, int off, int size2) throws IOException {
        int length;
        int readSize;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || size2 < 0 || size2 > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (size2 == 0) {
            return 0;
        }
        for (length = size2; length > 0 && (this.dataSize > this.pos || !this.eof && this.fillBuffer() != 0); length -= readSize) {
            int availData = this.dataSize - this.pos;
            readSize = availData < length ? availData : length;
            System.arraycopy(this.buffer, this.pos, buf, size2 - length + off, readSize);
            this.pos += readSize;
        }
        return size2 - length;
    }

    private int readInternal(byte[] buf) throws IOException {
        int length;
        int len;
        int size2 = buf.length;
        for (length = 0; length < size2 && (len = this.in.read(buf, length, size2 - length)) > 0; length += len) {
        }
        if (length == 0) {
            this.eof = true;
        }
        return length;
    }
}

