/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class VolumeOutputStream
extends OutputStream {
    private Connection conn = null;
    private long totalBytes;
    private OutputStream out;
    private CRC32 crc = new CRC32();
    private final int CHUNK_SIZE = 524288;
    private int chunkOffset;
    private boolean init;
    private Deflater def;
    private boolean isClosed = true;
    Response resp;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VolumeOutputStream(Connection conn, CompressOption option) throws IOException {
        if (option != null) {
            if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) throw new IOException("invalid compression option.");
            this.def = new Deflater();
            this.def.setLevel(option.level);
            this.def.setStrategy(option.strategy);
            this.out = new DeflaterOutputStream(conn.getOutputStream(), this.def);
        } else {
            this.out = conn.getOutputStream();
        }
        this.conn = conn;
        this.init = false;
        this.isClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = ByteBuffer.allocate(1).array();
        bytes[0] = (byte)(b & 0xFF);
        this.write(bytes);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (!this.init) {
            this.init = true;
            this.writeInt(524288);
            this.crcInt(524288);
            this.chunkOffset = 0;
        }
        if (this.chunkOffset != 0) {
            int checkSum = (int)this.crc.getValue();
            this.writeInt(checkSum);
        }
        this.out.close();
        try {
            this.resp = this.conn.getResponse();
            if (!this.resp.isOK()) {
                InputStream in = this.conn.getInputStream();
                TunnelException err = null;
                err = in == null ? new TunnelException(this.conn.getResponse().getMessage()) : new TunnelException(this.conn.getInputStream());
                err.setRequestId(this.resp.getHeader("x-odps-request-id"));
                throw new IOException(err);
            }
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
            this.conn.disconnect();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (!this.init) {
            this.init = true;
            this.writeInt(524288);
            this.crcInt(524288);
            this.chunkOffset = 0;
        }
        if (buf == null || buf.length == 0) {
            throw new IOException("Invalid Protobuf Data Buffer!");
        }
        int bytes = 0;
        while (bytes < len) {
            if (this.chunkOffset == 524288) {
                int checkSum = (int)this.crc.getValue();
                this.writeInt(checkSum);
                this.chunkOffset = 0;
                continue;
            }
            int size2 = len - bytes > 524288 - this.chunkOffset ? 524288 - this.chunkOffset : len - bytes;
            this.out.write(buf, off + bytes, size2);
            this.crc.update(buf, off + bytes, size2);
            bytes += size2;
            this.chunkOffset += size2;
        }
        this.totalBytes += (long)len;
    }

    private void writeInt(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
        this.out.write(bytes);
    }

    private void crcInt(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
        this.crc.update(bytes);
    }

    public long getBytes() {
        return this.totalBytes;
    }

    public Response getResp() {
        return this.resp;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

