/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.conf.Configurable;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.io.DataInputBuffer;
import com.aliyun.odps.io.DataOutputBuffer;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Writable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.util.SecurityConstants;

public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final ConcurrentHashMap<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static ThreadLocal<CopyInCopyOutBuffer> cloneBuffers = new ThreadLocal<CopyInCopyOutBuffer>(){

        @Override
        protected synchronized CopyInCopyOutBuffer initialValue() {
            return new CopyInCopyOutBuffer();
        }
    };

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null && theObject instanceof Configurable) {
            ((Configurable)theObject).setConf(conf);
        }
    }

    private static void checkMemberAccess(final Class<?> theClass, Member theMember) {
        if (theMember == null || Modifier.isPublic(theMember.getModifiers())) {
            return;
        }
        SecurityManager s2 = System.getSecurityManager();
        if (s2 == null) {
            return;
        }
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ReflectionUtils.class.getClassLoader() == theClass.getClassLoader().getParent();
            }
        }).booleanValue()) {
            return;
        }
        s2.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        s2.checkPermission(new ReflectPermission("suppressAccessChecks"));
    }

    public static <T> T newInstance(final Class<T> theClass, Configuration conf) {
        Object result2;
        Constructor retMethod = CONSTRUCTOR_CACHE.get(theClass);
        if (retMethod == null) {
            try {
                retMethod = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                    @Override
                    public Constructor<T> run() throws NoSuchMethodException {
                        Constructor ret = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                        ret.setAccessible(true);
                        return ret;
                    }
                });
                ReflectionUtils.checkMemberAccess(theClass, retMethod);
                CONSTRUCTOR_CACHE.putIfAbsent(theClass, retMethod);
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            result2 = retMethod.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result2, conf);
        return (T)result2;
    }

    public static <T> T newInstanceFast(Class<T> theClass, Configuration configuration) {
        T result2 = null;
        if (theClass.equals(NullWritable.class)) {
            return (T)NullWritable.get();
        }
        try {
            result2 = theClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result2, configuration);
        return result2;
    }

    static void clearCache() {
        CONSTRUCTOR_CACHE.clear();
    }

    static int getCacheSize() {
        return CONSTRUCTOR_CACHE.size();
    }

    @Deprecated
    public static Method findUserClassMethod(final Class<?> inClass, final String methodName) {
        Method retMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                for (Method method : inClass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method;
                }
                return null;
            }
        });
        ReflectionUtils.checkMemberAccess(inClass, retMethod);
        return retMethod;
    }

    public static List<Method> findUserClassMethods(final Class<?> inClass, final String methodName) {
        List<Method> retMethod = AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Method method : inClass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    methods.add(method);
                }
                return methods;
            }
        });
        for (Method m3 : retMethod) {
            ReflectionUtils.checkMemberAccess(inClass, m3);
        }
        return retMethod;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static void setField(Object target, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field2 = ReflectionUtils.findDeclaredField(target.getClass(), fieldname);
        field2.setAccessible(true);
        field2.set(target, value);
    }

    public static Field findDeclaredField(Class<?> inClass, String fieldname) throws NoSuchFieldException {
        while (!Object.class.equals(inClass)) {
            for (Field field2 : inClass.getDeclaredFields()) {
                if (!field2.getName().equals(fieldname)) continue;
                return field2;
            }
            inClass = inClass.getSuperclass();
        }
        String msg = "Class '" + inClass.getName() + "' has no field '" + fieldname + "'";
        throw new NoSuchFieldException(msg);
    }

    public static Method findDeclaredMethodRecursive(Class<?> inClass, String methodName) throws NoSuchMethodException {
        while (!Object.class.equals(inClass)) {
            for (Method method : inClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
            inClass = inClass.getSuperclass();
        }
        String msg = "ODPS-0730001: Class '" + inClass.getName() + "' not implement method '" + methodName + "'";
        throw new NoSuchMethodException(msg);
    }

    public static Method findDeclaredMethod(Class<?> inClass, String methodName) {
        if (!Object.class.equals(inClass)) {
            for (Method method : inClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        }
        String msg = "ODPS-0730001: Class '" + inClass.getName() + "' not implement method '" + methodName + "'";
        throw new RuntimeException(msg);
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectionUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectionUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static void checkNonStaticField(Class<?> userImplClass, Class<?> parentClass) {
        while (!parentClass.equals(userImplClass)) {
            Field[] fields = userImplClass.getDeclaredFields();
            ArrayList<Field> nonStaticFields = new ArrayList<Field>();
            for (Field field2 : fields) {
                if (Modifier.isStatic(field2.getModifiers())) continue;
                nonStaticFields.add(field2);
            }
            if (!nonStaticFields.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + ((Field)nonStaticFields.get(0)).getName());
                for (int i = 1; i < nonStaticFields.size(); ++i) {
                    sb.append("," + ((Field)nonStaticFields.get(i)).getName());
                }
                sb.append("]");
                throw new IllegalStateException("ODPS-0730001: Subclass of " + parentClass.getSimpleName() + " '" + userImplClass.getName() + "' must not have non-static member variables " + sb.toString() + ", put them into vertex value if really need.");
            }
            userImplClass = userImplClass.getSuperclass();
        }
    }

    @Deprecated
    public static void cloneWritableInto(Writable dst, Writable src) throws IOException {
        CopyInCopyOutBuffer buffer = cloneBuffers.get();
        buffer.outBuffer.reset();
        src.write(buffer.outBuffer);
        buffer.moveData();
        dst.readFields(buffer.inBuffer);
    }

    private static class CopyInCopyOutBuffer {
        DataOutputBuffer outBuffer = new DataOutputBuffer();
        DataInputBuffer inBuffer = new DataInputBuffer();

        private CopyInCopyOutBuffer() {
        }

        void moveData() {
            this.inBuffer.reset(this.outBuffer.getData(), this.outBuffer.getLength());
        }
    }
}

