/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.source;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.source.MaxcomputeSourceReader;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.source.MaxcomputeSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.source.MaxcomputeSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.source.MaxcomputeSourceState;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.util.MaxcomputeTypeMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelSource.class})
public class MaxcomputeSource
implements SeaTunnelSource<SeaTunnelRow, MaxcomputeSourceSplit, MaxcomputeSourceState>,
SupportParallelism {
    private static final Logger log = LoggerFactory.getLogger(MaxcomputeSource.class);
    private SeaTunnelRowType typeInfo;
    private Config pluginConfig;

    public String getPluginName() {
        return "Maxcompute";
    }

    public void prepare(Config pluginConfig) {
        this.typeInfo = MaxcomputeTypeMapper.getSeaTunnelRowType(pluginConfig);
        this.pluginConfig = pluginConfig;
    }

    public SeaTunnelRowType getProducedType() {
        return this.typeInfo;
    }

    public SourceReader<SeaTunnelRow, MaxcomputeSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        return new MaxcomputeSourceReader(this.pluginConfig, readerContext, this.typeInfo);
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SourceSplitEnumerator<MaxcomputeSourceSplit, MaxcomputeSourceState> createEnumerator(SourceSplitEnumerator.Context<MaxcomputeSourceSplit> enumeratorContext) throws Exception {
        return new MaxcomputeSourceSplitEnumerator(enumeratorContext, this.pluginConfig);
    }

    public SourceSplitEnumerator<MaxcomputeSourceSplit, MaxcomputeSourceState> restoreEnumerator(SourceSplitEnumerator.Context<MaxcomputeSourceSplit> enumeratorContext, MaxcomputeSourceState checkpointState) throws Exception {
        return new MaxcomputeSourceSplitEnumerator(enumeratorContext, this.pluginConfig, checkpointState);
    }
}

