/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.util;

import com.aliyun.odps.Column;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.SimpleArrayTypeInfo;
import com.aliyun.odps.type.SimpleMapTypeInfo;
import com.aliyun.odps.type.SimpleStructTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.exception.MaxcomputeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.util.MaxcomputeUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxcomputeTypeMapper
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MaxcomputeTypeMapper.class);

    public static SeaTunnelRow getSeaTunnelRowData(Record rs, SeaTunnelRowType typeInfo) {
        ArrayList<Object> fields = new ArrayList<Object>();
        SeaTunnelDataType[] seaTunnelDataTypes = typeInfo.getFieldTypes();
        for (int i = 0; i < rs.getColumns().length; ++i) {
            fields.add(MaxcomputeTypeMapper.resolveObject2SeaTunnel(rs.get(i), seaTunnelDataTypes[i]));
        }
        return new SeaTunnelRow(fields.toArray());
    }

    public static Record getMaxcomputeRowData(SeaTunnelRow seaTunnelRow, TableSchema tableSchema) {
        ArrayRecord arrayRecord = new ArrayRecord(tableSchema);
        List<Column> columns = tableSchema.getColumns();
        for (int i = 0; i < seaTunnelRow.getFields().length; ++i) {
            arrayRecord.set(i, MaxcomputeTypeMapper.resolveObject2Maxcompute(seaTunnelRow.getField(i), columns.get(i).getTypeInfo()));
        }
        return arrayRecord;
    }

    public static SeaTunnelRowType getSeaTunnelRowType(Config pluginConfig) {
        Table table = MaxcomputeUtil.getTable(pluginConfig);
        TableSchema tableSchema = table.getSchema();
        ArrayList seaTunnelDataTypes = new ArrayList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            for (int i = 0; i < tableSchema.getColumns().size(); ++i) {
                fieldNames.add(tableSchema.getColumns().get(i).getName());
                TypeInfo maxcomputeTypeInfo = tableSchema.getColumns().get(i).getTypeInfo();
                SeaTunnelDataType<?> seaTunnelDataType = MaxcomputeTypeMapper.maxcompute2SeaTunnelType(maxcomputeTypeInfo);
                seaTunnelDataTypes.add(seaTunnelDataType);
            }
        }
        catch (Exception e) {
            throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, (Throwable)e);
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[fieldNames.size()]), seaTunnelDataTypes.toArray(new SeaTunnelDataType[seaTunnelDataTypes.size()]));
    }

    private static SeaTunnelDataType<?> maxcompute2SeaTunnelType(TypeInfo typeInfo) {
        switch (typeInfo.getOdpsType()) {
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return new MapType(MaxcomputeTypeMapper.maxcompute2SeaTunnelType(mapTypeInfo.getKeyTypeInfo()), MaxcomputeTypeMapper.maxcompute2SeaTunnelType(mapTypeInfo.getValueTypeInfo()));
            }
            case ARRAY: {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                switch (arrayTypeInfo.getElementTypeInfo().getOdpsType()) {
                    case BOOLEAN: {
                        return ArrayType.BOOLEAN_ARRAY_TYPE;
                    }
                    case INT: {
                        return ArrayType.INT_ARRAY_TYPE;
                    }
                    case BIGINT: {
                        return ArrayType.LONG_ARRAY_TYPE;
                    }
                    case FLOAT: {
                        return ArrayType.FLOAT_ARRAY_TYPE;
                    }
                    case DOUBLE: {
                        return ArrayType.DOUBLE_ARRAY_TYPE;
                    }
                    case STRING: {
                        return ArrayType.STRING_ARRAY_TYPE;
                    }
                }
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", typeInfo.getTypeName()));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List<TypeInfo> fields = structTypeInfo.getFieldTypeInfos();
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                ArrayList fieldTypes = new ArrayList(fields.size());
                for (TypeInfo field2 : fields) {
                    fieldNames.add(field2.getTypeName());
                    fieldTypes.add(MaxcomputeTypeMapper.maxcompute2SeaTunnelType(field2));
                }
                return new SeaTunnelRowType(fieldNames.toArray(new String[0]), fieldTypes.toArray(new SeaTunnelDataType[0]));
            }
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case INT: {
                return BasicType.INT_TYPE;
            }
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case BINARY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                return new DecimalType(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return BasicType.STRING_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case VOID: {
                return BasicType.VOID_TYPE;
            }
        }
        throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", typeInfo.getTypeName()));
    }

    private static Object resolveObject2SeaTunnel(Object field2, SeaTunnelDataType<?> fieldType) {
        if (field2 == null) {
            return null;
        }
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                ArrayList origArray = new ArrayList();
                ((ArrayList)field2).iterator().forEachRemaining(origArray::add);
                BasicType elementType = ((ArrayType)fieldType).getElementType();
                switch (elementType.getSqlType()) {
                    case STRING: {
                        return origArray.toArray(new String[0]);
                    }
                    case BOOLEAN: {
                        return origArray.toArray(new Boolean[0]);
                    }
                    case INT: {
                        return origArray.toArray(new Integer[0]);
                    }
                    case BIGINT: {
                        return origArray.toArray(new Long[0]);
                    }
                    case FLOAT: {
                        return origArray.toArray(new Float[0]);
                    }
                    case DOUBLE: {
                        return origArray.toArray(new Double[0]);
                    }
                }
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", fieldType.getSqlType().name()));
            }
            case MAP: {
                HashMap dataMap = new HashMap();
                SeaTunnelDataType keyType = ((MapType)fieldType).getKeyType();
                SeaTunnelDataType valueType = ((MapType)fieldType).getValueType();
                HashMap origDataMap = (HashMap)field2;
                origDataMap.forEach((key, value) -> dataMap.put(MaxcomputeTypeMapper.resolveObject2SeaTunnel(key, keyType), MaxcomputeTypeMapper.resolveObject2SeaTunnel(value, valueType)));
                return dataMap;
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)fieldType).getFieldTypes();
                Object[] objects = new Object[fieldTypes.length];
                List<Object> fieldValues = ((SimpleStruct)field2).getFieldValues();
                for (int i = 0; i < fieldTypes.length; ++i) {
                    Object object;
                    objects[i] = object = MaxcomputeTypeMapper.resolveObject2SeaTunnel(fieldValues.get(i), fieldTypes[i]);
                }
                return new SeaTunnelRow(objects);
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case TINYINT: 
            case SMALLINT: {
                return field2;
            }
            case BYTES: {
                return ((Binary)field2).data();
            }
            case DECIMAL: {
                return null;
            }
            case STRING: {
                if (field2 instanceof byte[]) {
                    return new String((byte[])field2);
                }
                if (field2 instanceof Char) {
                    return MaxcomputeTypeMapper.rtrim(String.valueOf(field2));
                }
                return String.valueOf(field2);
            }
            case DATE: {
                if (field2 instanceof LocalDate) {
                    return Date.valueOf((LocalDate)field2);
                }
                return ((Date)field2).toLocalDate();
            }
            case TIME: {
                return ((Time)field2).toLocalTime();
            }
            case TIMESTAMP: {
                return ((java.util.Date)field2).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
        }
        throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", fieldType.getSqlType().name()));
    }

    private static Object resolveObject2Maxcompute(Object field2, TypeInfo typeInfo) {
        if (field2 == null) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case ARRAY: {
                ArrayList origArray = new ArrayList();
                Arrays.stream((Object[])field2).iterator().forEachRemaining(origArray::add);
                switch (((SimpleArrayTypeInfo)typeInfo).getElementTypeInfo().getOdpsType()) {
                    case BOOLEAN: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: {
                        return origArray;
                    }
                }
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Maxcompute type not support this type [%s] now", typeInfo.getTypeName()));
            }
            case MAP: {
                HashMap dataMap = new HashMap();
                TypeInfo keyTypeInfo = ((SimpleMapTypeInfo)typeInfo).getKeyTypeInfo();
                TypeInfo valueTypeInfo = ((SimpleMapTypeInfo)typeInfo).getValueTypeInfo();
                HashMap origDataMap = (HashMap)field2;
                origDataMap.forEach((key, value) -> dataMap.put(MaxcomputeTypeMapper.resolveObject2Maxcompute(key, keyTypeInfo), MaxcomputeTypeMapper.resolveObject2Maxcompute(value, valueTypeInfo)));
                return origDataMap;
            }
            case STRUCT: {
                Object[] fields = ((SeaTunnelRow)field2).getFields();
                List<TypeInfo> typeInfos = ((SimpleStructTypeInfo)typeInfo).getFieldTypeInfos();
                ArrayList<Object> origStruct = new ArrayList<Object>();
                for (int i = 0; i < fields.length; ++i) {
                    origStruct.add(MaxcomputeTypeMapper.resolveObject2Maxcompute(fields[i], typeInfos.get(i)));
                }
                return new SimpleStruct((StructTypeInfo)typeInfo, origStruct);
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case TINYINT: 
            case SMALLINT: {
                return field2;
            }
            case BINARY: {
                return new Binary((byte[])field2);
            }
            case DECIMAL: {
                return null;
            }
            case VARCHAR: {
                return new Varchar((String)field2);
            }
            case CHAR: {
                return new Char((String)field2);
            }
            case STRING: {
                if (field2 instanceof byte[]) {
                    return new String((byte[])field2);
                }
                if (field2 instanceof Char) {
                    return MaxcomputeTypeMapper.rtrim(String.valueOf(field2));
                }
                return String.valueOf(field2);
            }
            case TIMESTAMP: {
                return Timestamp.valueOf((LocalDateTime)field2);
            }
            case DATETIME: {
                return Date.from(((LocalDateTime)field2).atZone(ZoneId.systemDefault()).toInstant());
            }
            case DATE: {
                return Date.valueOf((LocalDate)field2);
            }
        }
        throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Maxcompute type not support this type [%s] now", typeInfo.getTypeName()));
    }

    private static String rtrim(String s2) {
        int i;
        for (i = s2.length() - 1; i >= 0 && Character.isWhitespace(s2.charAt(i)); --i) {
        }
        return s2.substring(0, i + 1);
    }
}

