/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Job;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.LogType;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.codec.binary.Base64;

public class Instance
extends LazyLoad {
    private String project;
    private Map<String, Result> results;
    private boolean isSync = false;
    private TaskStatusModel model;
    private Status status;
    private RestClient client;
    private Odps odps;
    private boolean hookInvoked = false;
    private OdpsHooks hooks;

    Instance(String project, TaskStatusModel model, Map<String, Result> results, Odps odps) {
        this.project = project;
        this.model = model;
        this.results = results;
        if (model.status != null) {
            this.status = Status.valueOf(model.status.toUpperCase());
        }
        if (results != null && results.size() > 0) {
            this.isSync = true;
            this.status = Status.TERMINATED;
        }
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    @Override
    public void reload() throws OdpsException {
        this.reload(false);
    }

    private void reload(boolean isBlock) throws OdpsException {
        HashMap<String, String> params = null;
        if (isBlock) {
            params = new HashMap<String, String>();
            params.put("instancestatus", null);
        }
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        this.model.owner = resp.getHeaders().get("x-odps-owner");
        String startTimeStr = resp.getHeaders().get("x-odps-start-time");
        String endTimeStr = resp.getHeaders().get("x-odps-end-time");
        try {
            this.model.startTime = DateUtils.parseRfc822Date(startTimeStr);
        }
        catch (ParseException e) {
            throw new OdpsException("Invalid response, x-odps-start-time:" + startTimeStr);
        }
        try {
            this.model.endTime = DateUtils.parseRfc822Date(endTimeStr);
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            InstanceStatusModel sm = JAXBUtils.unmarshal(resp, InstanceStatusModel.class);
            this.status = Status.valueOf(sm.status.toUpperCase());
        }
        catch (JAXBException e) {
            throw new OdpsException("Invalid instance status response.", e);
        }
    }

    public void stop() throws OdpsException {
        InstanceStatusModel sm = new InstanceStatusModel();
        sm.status = "Terminated";
        try {
            String ret = JAXBUtils.marshal(sm, InstanceStatusModel.class);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            this.client.stringRequest(this.getResource(), "PUT", null, headers, ret);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Map<String, Result> getTaskResultsWithFormat() throws OdpsException {
        if (this.isSync) {
            return this.results;
        }
        this.results = new HashMap<String, Result>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("result", null);
        InstanceResultModel rm = this.client.request(InstanceResultModel.class, this.getResource(), "GET", params);
        for (InstanceResultModel.TaskResult r : rm.taskResults) {
            this.results.put(r.name, r.result);
        }
        return this.results;
    }

    public Map<String, String> getTaskResults() throws OdpsException {
        Map<String, Result> results = this.getTaskResultsWithFormat();
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Map.Entry<String, Result> entry : results.entrySet()) {
            result2.put(entry.getKey(), entry.getValue().getString());
        }
        return result2;
    }

    public TaskCost getTaskCost(String taskName) throws OdpsException {
        TaskSummary summary = this.getTaskSummary(taskName);
        if (summary == null) {
            return null;
        }
        try {
            if (summary.get("Cost") != null) {
                Map taskCostMap = (Map)summary.get("Cost");
                TaskCost cost = new TaskCost();
                if (taskCostMap.get("CPU") != null) {
                    cost.setCPUCost((Integer)taskCostMap.get("CPU"));
                }
                if (taskCostMap.get("Memory") != null) {
                    cost.setMemoryCost((Integer)taskCostMap.get("Memory"));
                }
                if (taskCostMap.get("Input") != null) {
                    cost.setInputSize((Integer)taskCostMap.get("Input"));
                }
                return cost;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getTaskInfo(String taskName, String infoKey) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("info", null);
        params.put("taskname", taskName);
        params.put("key", infoKey);
        Response result2 = this.client.request(this.getResource(), "GET", params, null, null);
        try {
            return new String(result2.getBody(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e);
        }
    }

    public String setTaskInfo(String taskName, String infoKey, String infoValue) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("info", null);
        params.put("taskname", taskName);
        InstanceTaskInfoModel sm = new InstanceTaskInfoModel();
        sm.key = infoKey;
        sm.value = infoValue;
        try {
            String kv = JAXBUtils.marshal(sm, InstanceTaskInfoModel.class);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            Response result2 = this.client.stringRequest(this.getResource(), "PUT", params, headers, kv);
            return new String(result2.getBody(), "utf-8");
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public TaskSummary getTaskSummary(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancesummary", null);
        params.put("taskname", taskName);
        Response result2 = this.client.request(this.getResource(), "GET", params, null, null);
        TaskSummary summary = null;
        try {
            Gson gson = GsonObjectBuilder.get();
            Map map2 = (Map)gson.fromJson(new String(result2.getBody()), new TypeToken<Map<Object, Object>>(){}.getType());
            if (map2.get("Instance") != null) {
                Map mapReduce = (Map)map2.get("Instance");
                String jsonSummary = (String)mapReduce.get("JsonSummary");
                if (jsonSummary != null) {
                    summary = gson.fromJson(jsonSummary, TaskSummary.class);
                }
                if (summary != null) {
                    summary.setSummaryText((String)mapReduce.get("Summary"));
                    summary.setJsonSummary(jsonSummary);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return summary;
    }

    public Map<String, TaskStatus> getTaskStatus() throws OdpsException {
        HashMap<String, TaskStatus> taskStatus = new HashMap<String, TaskStatus>();
        TaskStatusModel taskStatusModel = this.model;
        if (!this.isSync || !this.hasTaskStatus(taskStatusModel)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taskstatus", null);
            taskStatusModel = this.client.request(TaskStatusModel.class, this.getResource(), "GET", params);
        }
        for (TaskStatusModel.InstanceTaskModel taskModel : taskStatusModel.tasks) {
            TaskStatus status = new TaskStatus(taskModel);
            taskStatus.put(status.getName(), status);
        }
        return taskStatus;
    }

    private boolean hasTaskStatus(TaskStatusModel model) {
        for (TaskStatusModel.InstanceTaskModel taskModel : model.tasks) {
            TaskStatus status = new TaskStatus(taskModel);
            if (((TaskStatus)status).model.status != null) continue;
            return false;
        }
        return true;
    }

    public Set<String> getTaskNames() throws OdpsException {
        return this.getTaskStatus().keySet();
    }

    public boolean isSuccessful() throws OdpsException {
        boolean r = true;
        Map<String, TaskStatus> status = this.getTaskStatus();
        for (TaskStatus s2 : status.values()) {
            if (s2.getStatus() == TaskStatus.Status.SUCCESS) continue;
            r = false;
            break;
        }
        return r;
    }

    public void waitForSuccess() throws OdpsException {
        this.waitForSuccess(1000L);
    }

    public void waitForSuccess(long interval) throws OdpsException {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!this.isSuccessful()) {
            for (Map.Entry<String, TaskStatus> e : this.getTaskStatus().entrySet()) {
                if (e.getValue().getStatus() == TaskStatus.Status.FAILED) {
                    throw new OdpsException(this.getTaskResults().get(e.getKey()));
                }
                if (e.getValue().getStatus() == TaskStatus.Status.SUCCESS) continue;
                throw new OdpsException(e.getKey() + ", Status=" + (Object)((Object)e.getValue().getStatus()));
            }
        }
    }

    public static String getStageProgressFormattedString(List<StageProgress> stages) {
        StringBuilder result2 = new StringBuilder();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sim.format(new Date());
        result2.append(dateString + ' ');
        for (StageProgress stage : stages) {
            result2.append(String.format("%s:%s/%s/%s%s%s", stage.getName(), stage.getRunningWorkers(), stage.getTerminatedWorkers(), stage.getTotalWorkers(), stage.getBackupWorkers() > 0 ? "(+" + stage.getBackupWorkers() + " backups)" : "", "[" + stage.getFinishedPercentage() + "%]\t"));
        }
        return result2.toString();
    }

    public List<StageProgress> getTaskProgress(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceprogress", taskName);
        params.put("taskname", taskName);
        TaskProgress r = this.client.request(TaskProgress.class, this.getResource(), "GET", params);
        return r.getStages();
    }

    public Odps getOdps() {
        return this.odps;
    }

    public String getId() {
        return this.model.name;
    }

    public Status getStatus(boolean isBlock) {
        if (this.status != Status.TERMINATED) {
            try {
                this.reload(isBlock);
            }
            catch (OdpsException e) {
                throw new ReloadException(e.getMessage(), e);
            }
        }
        try {
            if (this.hooks != null && this.status == Status.TERMINATED && !this.hookInvoked) {
                this.hookInvoked = true;
                this.hooks.after(this, this.odps);
            }
        }
        catch (OdpsException e) {
            throw new ReloadException(e.getMessage(), e);
        }
        return this.status;
    }

    public Status getStatus() {
        return this.getStatus(false);
    }

    public boolean isTerminated() {
        return this.getStatus() == Status.TERMINATED;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getStartTime() {
        if (this.model.startTime == null) {
            this.lazyLoad();
        }
        return this.model.startTime;
    }

    public Date getEndTime() {
        if (this.model.endTime == null) {
            this.lazyLoad();
        }
        return this.model.endTime;
    }

    public List<Task> getTasks() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getTasks();
    }

    public int getPriority() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getPriority();
    }

    private Job getJob(String resource) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", null);
        Job.JobModel model = this.client.request(Job.JobModel.class, resource, "GET", params, null, null);
        return new Job(model);
    }

    public String getJobName() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getName();
    }

    private String getResource() {
        return ResourceBuilder.buildInstanceResource(this.project, this.model.name);
    }

    public String getLog(String workerId, LogType logType, int size2) throws OdpsException {
        if (workerId == null) {
            throw new OdpsException("Missing argument: workerId");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("log", null);
        params.put("id", workerId);
        if (logType != null) {
            params.put("logtype", logType.toString());
        }
        if (size2 > 0) {
            params.put("size", String.valueOf(size2));
        }
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(resp.getBody());
    }

    public String getTaskDetailJson(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancedetail", null);
        params.put("taskname", taskName);
        Response result2 = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result2.getBody());
    }

    public OdpsHooks getOdpsHooks() {
        return this.hooks;
    }

    public void setOdpsHooks(OdpsHooks hooks) {
        this.hooks = hooks;
    }

    public boolean isHookInvoked() {
        return this.hookInvoked;
    }

    public void setHookInvoked(boolean hookInvoked) {
        this.hookInvoked = hookInvoked;
    }

    public String getTaskDetailJson2(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("detail", null);
        params.put("taskname", taskName);
        Response result2 = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result2.getBody());
    }

    public String getTaskQuotaJson(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancequota", null);
        params.put("taskname", taskName);
        Response result2 = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result2.getBody());
    }

    public String startDebug(String workerId, String debugId) throws OdpsException {
        if (workerId == null) {
            throw new OdpsException("Missing argument: workerId");
        }
        if (debugId == null) {
            throw new OdpsException("Missing argument: debugId");
        }
        InstanceDebugModel model = new InstanceDebugModel();
        model.debugId = debugId;
        model.logId = workerId;
        try {
            String body = JAXBUtils.marshal(model, InstanceDebugModel.class);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            Response resp = this.client.stringRequest(this.getResource() + "/debug", "POST", null, headers, body);
            return new String(resp.getBody());
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public InstanceQueueingInfo getQueueingInfo() throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cached", null);
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        Gson gson = GsonObjectBuilder.get();
        JsonObject object = gson.fromJson(new String(resp.getBody()), JsonObject.class);
        return new InstanceQueueingInfo(object);
    }

    public static class InstanceQueueingInfo {
        JsonObject properties;

        InstanceQueueingInfo(JsonObject props) {
            this.properties = props;
        }

        public <T> T getProperty(String key, Class<T> clz) {
            if (this.properties.get(key) == null) {
                return null;
            }
            return this.cast(this.properties.get(key), clz);
        }

        private <T> T cast(Object object, Class<T> clz) {
            if (object instanceof JsonPrimitive) {
                if (clz.equals(Integer.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsInt());
                }
                if (clz.equals(Short.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsShort());
                }
                if (clz.equals(Boolean.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsBoolean());
                }
                if (clz.equals(Double.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsDouble());
                }
                if (clz.equals(Long.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsLong());
                }
                if (clz.equals(Float.class)) {
                    return clz.cast(Float.valueOf(((JsonPrimitive)object).getAsFloat()));
                }
                if (clz.equals(String.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsString());
                }
                if (clz.equals(Byte.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsByte());
                }
            } else {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                return gson.fromJson(gson.toJson(object), clz);
            }
            return null;
        }

        public String getId() {
            return this.properties.has("instanceId") ? this.properties.get("instanceId").getAsString() : null;
        }

        public Integer getPriority() {
            return this.properties.has("instancePriority") ? Integer.valueOf(this.properties.get("instancePriority").getAsInt()) : null;
        }

        public Double getProgress() {
            return this.properties.has("instanceProgress") ? Double.valueOf(this.properties.get("instanceProgress").getAsDouble()) : null;
        }

        public String getJobName() {
            return this.properties.has("jobName") ? this.properties.get("jobName").getAsString() : null;
        }

        public String getProject() {
            return this.properties.has("projectName") ? this.properties.get("projectName").getAsString() : null;
        }

        public String getSkyNetId() {
            return this.properties.has("skynetId") ? this.properties.get("skynetId").getAsString() : null;
        }

        public Date getStartTime() {
            String startTimeStr = this.properties.get("startTime").getAsString();
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            Date startTime = null;
            try {
                startTime = format2.parse(startTimeStr);
            }
            catch (ParseException e1) {
                try {
                    startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ").parse(startTimeStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return startTime;
        }

        public String getTaskType() {
            return this.properties.get("taskType").getAsString();
        }

        public String getTaskName() {
            return this.properties.get("taskName").getAsString();
        }

        public String getUserAccount() {
            return this.properties.get("userAccount").getAsString();
        }

        public Status getStatus() {
            if (!this.properties.has("status")) {
                return null;
            }
            String status = this.properties.get("status").getAsString();
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (Exception e) {
                return Status.UNKNOWN;
            }
        }

        public static enum Status {
            RUNNING,
            SUSPENDED,
            TERMINATED,
            UNKNOWN;

        }
    }

    @XmlRootElement(name="Progress")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class TaskProgress {
        @XmlElement(name="Stage")
        List<StageProgress> stages = new LinkedList<StageProgress>();

        private TaskProgress() {
        }

        List<StageProgress> getStages() {
            return this.stages;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StageProgress {
        @XmlAttribute(name="ID")
        String name;
        @XmlElement(name="Status")
        String status;
        @XmlElement(name="BackupWorkers")
        int backupSysInstances;
        @XmlElement(name="TerminatedWorkers")
        int terminatedSysInstances;
        @XmlElement(name="RunningWorkers")
        int runningSysInstances;
        @XmlElement(name="TotalWorkers")
        int totalSysInstances;
        @XmlElement(name="InputRecords")
        long inputRecords;
        @XmlElement(name="OutputRecords")
        long outputRecords;
        @XmlElement(name="FinishedPercentage")
        int finishedPercentage;

        public Status getStatus() {
            if (this.status == null) {
                return null;
            }
            return Status.valueOf(this.status.toUpperCase());
        }

        public int getBackupWorkers() {
            return this.backupSysInstances;
        }

        public int getRunningWorkers() {
            return this.runningSysInstances;
        }

        public String getName() {
            return this.name;
        }

        public int getTerminatedWorkers() {
            return this.terminatedSysInstances;
        }

        public int getTotalWorkers() {
            return this.totalSysInstances;
        }

        public long getInputRecords() {
            return this.inputRecords;
        }

        public long getOutputRecords() {
            return this.outputRecords;
        }

        public int getFinishedPercentage() {
            return this.finishedPercentage;
        }

        public static enum Status {
            READY,
            WAITING,
            RUNNING,
            SUSPENDED,
            FAILED,
            TERMINATED,
            CANCELLED,
            CANCELLING;

        }
    }

    public static class TaskStatus {
        private TaskStatusModel.InstanceTaskModel model;

        TaskStatus(TaskStatusModel.InstanceTaskModel model) {
            this.model = model;
        }

        public String getName() {
            return this.model.name;
        }

        public String getType() {
            return this.model.type;
        }

        public Status getStatus() {
            return Status.valueOf(this.model.status.toUpperCase());
        }

        public static enum Status {
            WAITING,
            RUNNING,
            SUCCESS,
            FAILED,
            SUSPENDED,
            CANCELLED;

        }
    }

    @XmlRootElement(name="Instance")
    static class TaskStatusModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="StartTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date startTime;
        @XmlElement(name="EndTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date endTime;
        @XmlElement(name="Status")
        String status;
        @XmlElementWrapper(name="Tasks")
        @XmlElement(name="Task")
        List<InstanceTaskModel> tasks = new ArrayList<InstanceTaskModel>();

        TaskStatusModel() {
        }

        static class InstanceTaskModel {
            @XmlElement(name="Name")
            String name;
            @XmlAttribute(name="Type")
            String type;
            @XmlElement(name="StartTime")
            @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
            Date startTime;
            @XmlElement(name="EndTime")
            @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
            Date endTime;
            @XmlElement(name="Status")
            String status;
            @XmlElementWrapper(name="Histories")
            @XmlElement(name="History")
            List<InstanceTaskModel> histories = new ArrayList<InstanceTaskModel>();

            InstanceTaskModel() {
            }
        }
    }

    public static class TaskSummary
    extends HashMap {
        private String text;
        private String jsonSummary = "{}";

        public String getSummaryText() {
            return this.text;
        }

        void setSummaryText(String text) {
            this.text = text;
        }

        public String getJsonSummary() {
            return this.jsonSummary;
        }

        void setJsonSummary(String jsonSummary) {
            this.jsonSummary = jsonSummary;
        }
    }

    public static class TaskCost {
        private Integer cpuCost = 0;
        private Integer memoryCost = 0;
        private Integer inputSize = 0;

        public Integer getCPUCost() {
            return this.cpuCost;
        }

        public void setCPUCost(Integer cpuCost) {
            this.cpuCost = cpuCost;
        }

        public Integer getMemoryCost() {
            return this.memoryCost;
        }

        public void setMemoryCost(Integer memoryCost) {
            this.memoryCost = memoryCost;
        }

        public Integer getInputSize() {
            return this.inputSize;
        }

        public void setInputSize(Integer inputSize) {
            this.inputSize = inputSize;
        }
    }

    @XmlRootElement(name="Instance")
    static class InstanceTaskInfoModel {
        @XmlElement(name="Key")
        String key;
        @XmlElement(name="Value")
        String value;

        InstanceTaskInfoModel() {
        }
    }

    @XmlRootElement
    public static class Result {
        @XmlAttribute(name="Transform")
        String transform;
        @XmlAttribute(name="Format")
        String format;
        @XmlValue
        String text;

        public String getString() {
            if (this.transform != null && "Base64".equals(this.transform)) {
                try {
                    String decodedString = new String(Base64.decodeBase64(this.text), "UTF-8");
                    return decodedString;
                }
                catch (Exception e) {
                    return this.text;
                }
            }
            return this.text;
        }

        public String getFormat() {
            return this.format;
        }
    }

    @XmlRootElement(name="Instance")
    static class InstanceResultModel {
        @XmlElementWrapper(name="Tasks")
        @XmlElement(name="Task")
        List<TaskResult> taskResults = new ArrayList<TaskResult>();

        InstanceResultModel() {
        }

        static class TaskResult {
            @XmlAttribute(name="Type")
            String type;
            @XmlElement(name="Name")
            String name;
            @XmlElement(name="Result")
            Result result;
            @XmlElement(name="Status")
            String status;

            TaskResult() {
            }
        }
    }

    @XmlRootElement
    private static class InstanceDebugModel {
        @XmlElement(name="LogId")
        String logId;
        @XmlElement(name="DebugId")
        String debugId;

        private InstanceDebugModel() {
        }
    }

    @XmlRootElement(name="Instance")
    private static class InstanceStatusModel {
        @XmlElement(name="Status")
        String status;

        private InstanceStatusModel() {
        }
    }

    public static enum Status {
        RUNNING("Running"),
        SUSPENDED("Suspended"),
        TERMINATED("Terminated");

        private static final Map<String, Status> strToEnum;
        private String strVal;

        private Status(String strVal) {
            this.strVal = strVal;
        }

        static Status fromString(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return strToEnum.get(value);
        }

        public String toString() {
            return this.strVal;
        }

        static {
            strToEnum = new HashMap<String, Status>();
            for (Status t : Status.values()) {
                strToEnum.put(t.toString(), t);
            }
        }
    }
}

