/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Table;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Partition
extends LazyLoad {
    private PartitionModel model;
    private PartitionSpec spec;
    private String project;
    private String table;
    private RestClient client;
    private long size;
    private boolean isExtendInfoLoaded;
    private boolean isArchived;
    private boolean isExstore;
    private long lifeCycle;
    private long physicalSize;
    private long fileNum;
    private String reserved;
    private Table.ClusterInfo clusterInfo;

    Partition(PartitionModel model, String projectName, String tableName, RestClient client) {
        this.model = model;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
    }

    Partition(PartitionSpec spec, String projectName, String tableName, RestClient client) {
        this.spec = spec;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
        this.model = new PartitionModel();
    }

    public PartitionSpec getPartitionSpec() {
        if (this.spec != null) {
            return this.spec;
        }
        this.spec = new PartitionSpec();
        for (ColumnModel c : this.model.columns) {
            this.spec.set(c.columnName, c.columnValue);
        }
        return this.spec;
    }

    public Date getCreatedTime() {
        if (this.model == null || this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model == null || this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public Date getLastDataModifiedTime() {
        if (this.model == null || this.model.lastDataModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastDataModifiedTime;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.isArchived;
    }

    public boolean isExstore() {
        this.lazyLoadExtendInfo();
        return this.isExstore;
    }

    public long getLifeCycle() {
        this.lazyLoadExtendInfo();
        return this.lifeCycle;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.fileNum;
    }

    public long getSize() {
        this.lazyLoad();
        return this.size;
    }

    public String getReserved() {
        if (this.reserved == null) {
            this.lazyLoadExtendInfo();
        }
        return this.reserved;
    }

    public Table.ClusterInfo getClusterInfo() {
        if (this.clusterInfo == null) {
            this.lazyLoadExtendInfo();
        }
        return this.clusterInfo;
    }

    @Override
    public void reload() throws OdpsException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partition", this.getPartitionSpec().toString());
        String resource = ResourceBuilder.buildTableResource(this.project, this.table);
        PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
        try {
            JsonObject tree = new JsonParser().parse(meta.schema).getAsJsonObject();
            if (tree.has("createTime")) {
                this.model.createdTime = new Date(tree.get("createTime").getAsLong() * 1000L);
            }
            if (tree.has("lastDDLTime")) {
                this.model.lastMetaModifiedTime = new Date(tree.get("lastDDLTime").getAsLong() * 1000L);
            }
            if (tree.has("lastModifiedTime")) {
                this.model.lastDataModifiedTime = new Date(tree.get("lastModifiedTime").getAsLong() * 1000L);
            }
            if (tree.has("partitionSize")) {
                this.size = tree.get("partitionSize").getAsLong();
            }
            this.setLoaded(true);
        }
        catch (Exception e) {
            throw new OdpsException("Invalid partition meta", e);
        }
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("extended", null);
            params.put("partition", this.getPartitionSpec().toString());
            String resource = ResourceBuilder.buildTableResource(this.project, this.table);
            try {
                PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
                JsonObject tree = new JsonParser().parse(meta.schema).getAsJsonObject();
                if (tree.has("IsArchived")) {
                    this.isArchived = tree.get("IsArchived").getAsBoolean();
                }
                if (tree.has("IsExstore")) {
                    this.isExstore = tree.get("IsExstore").getAsBoolean();
                }
                if (tree.has("LifeCycle")) {
                    this.lifeCycle = tree.get("LifeCycle").getAsLong();
                }
                if (tree.has("PhysicalSize")) {
                    this.physicalSize = tree.get("PhysicalSize").getAsLong();
                }
                if (tree.has("FileNum")) {
                    this.fileNum = tree.get("FileNum").getAsLong();
                }
                if (tree.has("Reserved")) {
                    this.reserved = tree.get("Reserved").getAsString();
                    this.loadReservedJson(this.reserved);
                }
            }
            catch (Exception e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.isExtendInfoLoaded = true;
        }
    }

    private void loadReservedJson(String reserved) {
        JsonObject reservedJson = new JsonParser().parse(reserved).getAsJsonObject();
        this.clusterInfo = Table.parseClusterInfo(reservedJson);
    }

    @XmlRootElement(name="Partition")
    private static class PartitionMeta {
        @XmlElement(name="Schema")
        private String schema;

        private PartitionMeta() {
        }
    }

    @XmlRootElement(name="Column")
    static class ColumnModel {
        @XmlAttribute(name="Name")
        private String columnName;
        @XmlAttribute(name="Value")
        private String columnValue;

        ColumnModel() {
        }
    }

    @XmlRootElement(name="Partition")
    static class PartitionModel {
        @XmlElement(name="Column")
        private List<ColumnModel> columns = new ArrayList<ColumnModel>();
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.EpochBinding.class)
        Date createdTime;
        @XmlElement(name="LastDDLTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.EpochBinding.class)
        Date lastMetaModifiedTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.EpochBinding.class)
        Date lastDataModifiedTime;

        PartitionModel() {
        }
    }
}

