/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.VolumeFilter;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Volumes
implements Iterable<Volume> {
    private RestClient client;

    Volumes(RestClient client) {
        this.client = client;
    }

    public Volume get(String volumeName) {
        return this.get(this.getDefaultProjectName(), volumeName);
    }

    public Volume get(String projectName, String volumeName) {
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        Volume t = new Volume(model, projectName, this.client);
        return t;
    }

    public boolean exists(String volumeName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), volumeName);
    }

    public boolean exists(String projectName, String volumeName) throws OdpsException {
        try {
            Volume v = this.get(projectName, volumeName);
            v.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Volume> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Volume> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Volume> iterator(VolumeFilter filter2) {
        return this.iterator(this.getDefaultProjectName(), filter2);
    }

    public Iterator<Volume> iterator(final String projectName, final VolumeFilter filter2) {
        return new ListIterator<Volume>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Volume> list() {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter2 != null && filter2.getName() != null) {
                    this.params.put("name", filter2.getName());
                }
                String resource = ResourceBuilder.buildVolumesResource(projectName);
                try {
                    ListVolumesResponse resp = Volumes.this.client.request(ListVolumesResponse.class, resource, "GET", this.params);
                    for (Volume.VolumeModel model : resp.volumes) {
                        Volume t = new Volume(model, projectName, Volumes.this.client);
                        volumes.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return volumes;
            }
        };
    }

    @Deprecated
    public void create(String volumeName, String comment) throws OdpsException {
        this.create(this.client.getDefaultProject(), volumeName, comment);
    }

    @Deprecated
    public void create(String projectName, String volumeName, String comment) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        String xml = null;
        try {
            xml = JAXBUtils.marshal(model, Volume.VolumeModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void create(String volumeName, String comment, Volume.Type type) throws OdpsException {
        this.create(this.client.getDefaultProject(), volumeName, comment, type);
    }

    public void create(String projectName, String volumeName, String comment, Volume.Type type) throws OdpsException {
        this.create(projectName, volumeName, comment, type, null);
    }

    public void create(String projectName, String volumeName, String comment, Volume.Type type, Long lifecycle) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        if (type != null) {
            model.type = type.name().toLowerCase();
        }
        if (lifecycle != null) {
            model.lifecycle = lifecycle;
        }
        String xml = null;
        try {
            xml = JAXBUtils.marshal(model, Volume.VolumeModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void update(Volume volume) throws OdpsException {
        this.update(this.getDefaultProjectName(), volume);
    }

    public void update(String projectName, Volume volume) throws OdpsException {
        if (projectName == null || volume == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumeResource(projectName, volume.getName());
        String xml = null;
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.lifecycle = volume.getLifecycle();
        try {
            xml = JAXBUtils.marshal(model, Volume.VolumeModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "PUT", null, headers, xml);
    }

    public void delete(String volumeName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), volumeName);
    }

    public void delete(String projectName, String volumeName) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumeResource(projectName, volumeName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @XmlRootElement(name="Volumes")
    private static class ListVolumesResponse {
        @XmlElement(name="Volume")
        private List<Volume.VolumeModel> volumes = new ArrayList<Volume.VolumeModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListVolumesResponse() {
        }
    }
}

