/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.counter;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class CounterGroup
implements Iterable<Counter>,
Writable {
    private String name;
    private String displayName;
    private TreeMap<String, Counter> counters = new TreeMap();
    private ResourceBundle bundle = null;

    private static ResourceBundle getResourceBundle(String enumClassName) {
        String bundleName = enumClassName.replace('$', '_');
        return ResourceBundle.getBundle(bundleName);
    }

    protected CounterGroup(String name) {
        this.name = name;
        try {
            this.bundle = CounterGroup.getResourceBundle(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.displayName = this.localize("CounterGroupName", name);
    }

    protected CounterGroup(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    synchronized void addCounter(Counter counter) {
        this.counters.put(counter.getName(), counter);
    }

    protected Counter findCounter(String counterName, String displayName) {
        Counter result2 = this.counters.get(counterName);
        if (result2 == null) {
            result2 = new Counter(counterName, displayName);
            this.counters.put(counterName, result2);
        }
        return result2;
    }

    public synchronized Counter findCounter(String counterName) {
        Counter result2 = this.counters.get(counterName);
        if (result2 == null) {
            String displayName = this.localize(counterName, counterName);
            result2 = new Counter(counterName, displayName);
            this.counters.put(counterName, result2);
        }
        return result2;
    }

    @Override
    public synchronized Iterator<Counter> iterator() {
        return this.counters.values().iterator();
    }

    private String localize(String key, String defaultValue) {
        String result2 = defaultValue;
        if (this.bundle != null) {
            try {
                result2 = this.bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return result2;
    }

    public synchronized int size() {
        return this.counters.size();
    }

    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroup) {
            Iterator<Counter> right = ((CounterGroup)genericRight).counters.values().iterator();
            Iterator<Counter> left = this.counters.values().iterator();
            while (left.hasNext()) {
                if (right.hasNext() && left.next().equals(right.next())) continue;
                return false;
            }
            return !right.hasNext();
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.counters.hashCode();
    }

    public synchronized void incrAllCounters(CounterGroup rightGroup) {
        for (Counter right : rightGroup.counters.values()) {
            Counter left = this.findCounter(right.getName(), right.getDisplayName());
            left.increment(right.getValue());
        }
    }

    public synchronized void resetAllCounters() {
        for (Counter counter : this) {
            counter.setValue(0L);
        }
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString(out, this.displayName);
        WritableUtils.writeVInt(out, this.counters.size());
        for (Counter counter : this.counters.values()) {
            counter.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.displayName = Text.readString(in);
        this.counters.clear();
        int size2 = WritableUtils.readVInt(in);
        for (int i = 0; i < size2; ++i) {
            Counter counter = new Counter();
            counter.readFields(in);
            this.counters.put(counter.getName(), counter);
        }
    }
}

