/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import java.util.concurrent.TimeUnit;

public class IntervalDayTime
implements Comparable<IntervalDayTime> {
    private static final int NANOS_PER_SECOND = 1000000000;
    protected long totalSeconds;
    protected int nanos;

    public IntervalDayTime(long totalSeconds, int nanos) {
        if (nanos != 0) {
            long secondsFromNano = nanos / 1000000000;
            nanos %= 1000000000;
            totalSeconds += secondsFromNano;
        }
        this.totalSeconds = totalSeconds;
        this.nanos = nanos;
        if (totalSeconds > 0L && nanos < 0) {
            --totalSeconds;
            nanos += 1000000000;
        } else if (totalSeconds < 0L && nanos > 0) {
            ++totalSeconds;
            nanos -= 1000000000;
        }
    }

    public long getTotalSeconds() {
        return this.totalSeconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getDays() {
        return (int)TimeUnit.SECONDS.toDays(this.totalSeconds);
    }

    public int getHours() {
        return (int)(TimeUnit.SECONDS.toHours(this.totalSeconds) % TimeUnit.DAYS.toHours(1L));
    }

    public int getMinutes() {
        return (int)(TimeUnit.SECONDS.toMinutes(this.totalSeconds) % TimeUnit.HOURS.toMinutes(1L));
    }

    public int getSeconds() {
        return (int)(this.totalSeconds % TimeUnit.MINUTES.toSeconds(1L));
    }

    @Override
    public int compareTo(IntervalDayTime o) {
        long diffSeconds = this.totalSeconds - o.totalSeconds;
        return diffSeconds < 0L ? -1 : (diffSeconds == 0L ? this.nanos - o.nanos : 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalDayTime that = (IntervalDayTime)o;
        if (this.totalSeconds != that.totalSeconds) {
            return false;
        }
        return this.nanos == that.nanos;
    }

    public int hashCode() {
        int result2 = (int)(this.totalSeconds ^ this.totalSeconds >>> 32);
        result2 = 31 * result2 + this.nanos;
        return result2;
    }

    public String toString() {
        int nanos;
        int seconds;
        int minutes;
        int hours;
        int days;
        StringBuilder buf = new StringBuilder();
        if (this.totalSeconds < 0L || this.nanos < 0) {
            buf.append('-');
        }
        if ((days = this.getDays()) < 0) {
            days = -days;
        }
        if ((hours = this.getHours()) < 0) {
            hours = -hours;
        }
        if ((minutes = this.getMinutes()) < 0) {
            minutes = -minutes;
        }
        if ((seconds = this.getSeconds()) < 0) {
            seconds = -seconds;
        }
        if ((nanos = this.getNanos()) < 0) {
            nanos = -nanos;
        }
        buf.append(days);
        buf.append(String.format(" %02d:%02d:%02d.%09d", hours, minutes, seconds, nanos));
        return buf.toString();
    }
}

