/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.exception.MaxcomputeConnectorException;

public class SimpleStructTypeInfo
implements StructTypeInfo {
    private final List<String> fieldNames;
    private final List<TypeInfo> fieldTypeInfos;

    SimpleStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        this.validateParameters(names, typeInfos);
        this.fieldNames = this.toLowerCase(names);
        this.fieldTypeInfos = new ArrayList<TypeInfo>(typeInfos);
    }

    private List<String> toLowerCase(List<String> names) {
        ArrayList<String> lowerNames = new ArrayList<String>(names.size());
        for (String name : names) {
            lowerNames.add(name.toLowerCase());
        }
        return lowerNames;
    }

    private void validateParameters(List<String> names, List<TypeInfo> typeInfos) {
        if (names != null && typeInfos != null && !names.isEmpty() && !typeInfos.isEmpty()) {
            if (names.size() != typeInfos.size()) {
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "The amount of field names must be equal to the amount of field types.");
            }
        } else {
            throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Invalid name or element type for struct.");
        }
    }

    @Override
    public String getTypeName() {
        StringBuilder stringBuilder = new StringBuilder(this.getOdpsType().name());
        stringBuilder.append("<");
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.fieldNames.get(i));
            stringBuilder.append(":");
            stringBuilder.append(this.fieldTypeInfos.get(i).getTypeName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public List<TypeInfo> getFieldTypeInfos() {
        return this.fieldTypeInfos;
    }

    @Override
    public int getFieldCount() {
        return this.fieldNames.size();
    }

    @Override
    public OdpsType getOdpsType() {
        return OdpsType.STRUCT;
    }

    public String toString() {
        return this.getTypeName();
    }
}

