/*
 * Decompiled with CFR 0.152.
 */
package com.csvreader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.HashMap;

public class CsvReader {
    private Reader inputStream = null;
    private String fileName = null;
    private UserSettings userSettings = new UserSettings();
    private Charset charset = null;
    private boolean useCustomRecordDelimiter = false;
    private DataBuffer dataBuffer = new DataBuffer();
    private ColumnBuffer columnBuffer = new ColumnBuffer();
    private RawRecordBuffer rawBuffer = new RawRecordBuffer();
    private boolean[] isQualified = null;
    private String rawRecord = "";
    private HeadersHolder headersHolder = new HeadersHolder();
    private boolean startedColumn = false;
    private boolean startedWithQualifier = false;
    private boolean hasMoreData = true;
    private char lastLetter = '\u0000';
    private boolean hasReadNextLine = false;
    private int columnsCount = 0;
    private long currentRecord = 0L;
    private String[] values = new String[10];
    private boolean initialized = false;
    private boolean closed = false;
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;

    public CsvReader(String string2, char c, Charset charset) throws FileNotFoundException {
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset can not be null.");
        }
        if (!new File(string2).exists()) {
            throw new FileNotFoundException("File " + string2 + " does not exist.");
        }
        this.fileName = string2;
        this.userSettings.Delimiter = c;
        this.charset = charset;
        this.isQualified = new boolean[this.values.length];
    }

    public CsvReader(String string2, char c) throws FileNotFoundException {
        this(string2, c, Charset.forName("ISO-8859-1"));
    }

    public CsvReader(String string2) throws FileNotFoundException {
        this(string2, ',');
    }

    public CsvReader(Reader reader, char c) {
        if (reader == null) {
            throw new IllegalArgumentException("Parameter inputStream can not be null.");
        }
        this.inputStream = reader;
        this.userSettings.Delimiter = c;
        this.initialized = true;
        this.isQualified = new boolean[this.values.length];
    }

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(InputStream inputStream, char c, Charset charset) {
        this(new InputStreamReader(inputStream, charset), c);
    }

    public CsvReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public boolean getCaptureRawRecord() {
        return this.userSettings.CaptureRawRecord;
    }

    public void setCaptureRawRecord(boolean bl) {
        this.userSettings.CaptureRawRecord = bl;
    }

    public String getRawRecord() {
        return this.rawRecord;
    }

    public boolean getTrimWhitespace() {
        return this.userSettings.TrimWhitespace;
    }

    public void setTrimWhitespace(boolean bl) {
        this.userSettings.TrimWhitespace = bl;
    }

    public char getDelimiter() {
        return this.userSettings.Delimiter;
    }

    public void setDelimiter(char c) {
        this.userSettings.Delimiter = c;
    }

    public char getRecordDelimiter() {
        return this.userSettings.RecordDelimiter;
    }

    public void setRecordDelimiter(char c) {
        this.useCustomRecordDelimiter = true;
        this.userSettings.RecordDelimiter = c;
    }

    public char getTextQualifier() {
        return this.userSettings.TextQualifier;
    }

    public void setTextQualifier(char c) {
        this.userSettings.TextQualifier = c;
    }

    public boolean getUseTextQualifier() {
        return this.userSettings.UseTextQualifier;
    }

    public void setUseTextQualifier(boolean bl) {
        this.userSettings.UseTextQualifier = bl;
    }

    public char getComment() {
        return this.userSettings.Comment;
    }

    public void setComment(char c) {
        this.userSettings.Comment = c;
    }

    public boolean getUseComments() {
        return this.userSettings.UseComments;
    }

    public void setUseComments(boolean bl) {
        this.userSettings.UseComments = bl;
    }

    public int getEscapeMode() {
        return this.userSettings.EscapeMode;
    }

    public void setEscapeMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this.userSettings.EscapeMode = n;
    }

    public boolean getSkipEmptyRecords() {
        return this.userSettings.SkipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean bl) {
        this.userSettings.SkipEmptyRecords = bl;
    }

    public boolean getSafetySwitch() {
        return this.userSettings.SafetySwitch;
    }

    public void setSafetySwitch(boolean bl) {
        this.userSettings.SafetySwitch = bl;
    }

    public int getColumnCount() {
        return this.columnsCount;
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this.headersHolder.Length;
    }

    public String[] getHeaders() throws IOException {
        this.checkClosed();
        if (this.headersHolder.Headers == null) {
            return null;
        }
        String[] stringArray = new String[this.headersHolder.Length];
        System.arraycopy(this.headersHolder.Headers, 0, stringArray, 0, this.headersHolder.Length);
        return stringArray;
    }

    public void setHeaders(String[] stringArray) {
        this.headersHolder.Headers = stringArray;
        this.headersHolder.IndexByName.clear();
        this.headersHolder.Length = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < this.headersHolder.Length; ++i) {
            this.headersHolder.IndexByName.put(stringArray[i], new Integer(i));
        }
    }

    public String[] getValues() throws IOException {
        this.checkClosed();
        String[] stringArray = new String[this.columnsCount];
        System.arraycopy(this.values, 0, stringArray, 0, this.columnsCount);
        return stringArray;
    }

    public String get(int n) throws IOException {
        this.checkClosed();
        if (n > -1 && n < this.columnsCount) {
            return this.values[n];
        }
        return "";
    }

    public String get(String string2) throws IOException {
        this.checkClosed();
        return this.get(this.getIndex(string2));
    }

    public static CsvReader parse(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter data can not be null.");
        }
        return new CsvReader(new StringReader(string2));
    }

    public boolean readRecord() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        this.rawBuffer.Position = 0;
        this.dataBuffer.LineStart = this.dataBuffer.Position;
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            do {
                int n;
                char c;
                int n2;
                int n3;
                char c2;
                boolean bl;
                if (this.dataBuffer.Position == this.dataBuffer.Count) {
                    this.checkDataLength();
                    continue;
                }
                this.startedWithQualifier = false;
                char c3 = this.dataBuffer.Buffer[this.dataBuffer.Position];
                if (this.userSettings.UseTextQualifier && c3 == this.userSettings.TextQualifier) {
                    this.lastLetter = c3;
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                    this.startedWithQualifier = true;
                    bl = false;
                    c2 = this.userSettings.TextQualifier;
                    if (this.userSettings.EscapeMode == 2) {
                        c2 = '\\';
                    }
                    n3 = 0;
                    n2 = 0;
                    c = '\u0000';
                    n = 1;
                    int n4 = 0;
                    char c4 = '\u0000';
                    ++this.dataBuffer.Position;
                    do {
                        if (this.dataBuffer.Position == this.dataBuffer.Count) {
                            this.checkDataLength();
                            continue;
                        }
                        c3 = this.dataBuffer.Buffer[this.dataBuffer.Position];
                        if (n3 != 0) {
                            this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            if (c3 == this.userSettings.Delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (c3 == '\r' || c3 == '\n') || this.useCustomRecordDelimiter && c3 == this.userSettings.RecordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (c != '\u0000') {
                            ++n4;
                            switch (n) {
                                case 1: {
                                    c4 = (char)(c4 * 16);
                                    c4 = (char)(c4 + CsvReader.hexToDec(c3));
                                    if (n4 != 4) break;
                                    c = '\u0000';
                                    break;
                                }
                                case 2: {
                                    c4 = (char)(c4 * 8);
                                    c4 = (char)(c4 + (char)(c3 - 48));
                                    if (n4 != 3) break;
                                    c = '\u0000';
                                    break;
                                }
                                case 3: {
                                    c4 = (char)(c4 * 10);
                                    c4 = (char)(c4 + (char)(c3 - 48));
                                    if (n4 != 3) break;
                                    c = '\u0000';
                                    break;
                                }
                                case 4: {
                                    c4 = (char)(c4 * 16);
                                    c4 = (char)(c4 + CsvReader.hexToDec(c3));
                                    if (n4 != 2) break;
                                    c = '\u0000';
                                }
                            }
                            if (c == '\u0000') {
                                this.appendLetter(c4);
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            }
                        } else if (c3 == this.userSettings.TextQualifier) {
                            if (n2 != 0) {
                                n2 = 0;
                                bl = false;
                            } else {
                                this.updateCurrentValue();
                                if (this.userSettings.EscapeMode == 1) {
                                    n2 = 1;
                                }
                                bl = true;
                            }
                        } else if (this.userSettings.EscapeMode == 2 && n2 != 0) {
                            switch (c3) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    n = 2;
                                    c = '\u0001';
                                    n4 = 1;
                                    c4 = (char)(c3 - 48);
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (c3) {
                                        case 'U': 
                                        case 'u': {
                                            n = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            n = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            n = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            n = 3;
                                        }
                                    }
                                    c = '\u0001';
                                    n4 = 0;
                                    c4 = '\u0000';
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                            }
                            n2 = 0;
                        } else if (c3 == c2) {
                            this.updateCurrentValue();
                            n2 = 1;
                        } else if (bl) {
                            if (c3 == this.userSettings.Delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (c3 == '\r' || c3 == '\n') || this.useCustomRecordDelimiter && c3 == this.userSettings.RecordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                n3 = 1;
                            }
                            bl = false;
                        }
                        this.lastLetter = c3;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.Position;
                        if (!this.userSettings.SafetySwitch || this.dataBuffer.Position - this.dataBuffer.ColumnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false" + " if you're expecting column lengths greater than 100,000 characters to" + " avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                } else if (c3 == this.userSettings.Delimiter) {
                    this.lastLetter = c3;
                    this.endColumn();
                } else if (this.useCustomRecordDelimiter && c3 == this.userSettings.RecordDelimiter) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.SkipEmptyRecords) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
                    }
                    this.lastLetter = c3;
                } else if (!(this.useCustomRecordDelimiter || c3 != '\r' && c3 != '\n')) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.SkipEmptyRecords && (c3 == '\r' || this.lastLetter != '\r')) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
                    }
                    this.lastLetter = c3;
                } else if (this.userSettings.UseComments && this.columnsCount == 0 && c3 == this.userSettings.Comment) {
                    this.lastLetter = c3;
                    this.skipLine();
                } else if (this.userSettings.TrimWhitespace && (c3 == ' ' || c3 == '\t')) {
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position;
                    bl = false;
                    c2 = '\u0000';
                    n3 = 1;
                    n2 = 0;
                    c = '\u0000';
                    n = 1;
                    do {
                        if (n == 0 && this.dataBuffer.Position == this.dataBuffer.Count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (n == 0) {
                            c3 = this.dataBuffer.Buffer[this.dataBuffer.Position];
                        }
                        if (!this.userSettings.UseTextQualifier && this.userSettings.EscapeMode == 2 && c3 == '\\') {
                            if (bl) {
                                bl = false;
                            } else {
                                this.updateCurrentValue();
                                bl = true;
                            }
                        } else if (c2 != '\u0000') {
                            ++n2;
                            switch (n3) {
                                case 1: {
                                    c = (char)(c * 16);
                                    c = (char)(c + CsvReader.hexToDec(c3));
                                    if (n2 != 4) break;
                                    c2 = '\u0000';
                                    break;
                                }
                                case 2: {
                                    c = (char)(c * 8);
                                    c = (char)(c + (char)(c3 - 48));
                                    if (n2 != 3) break;
                                    c2 = '\u0000';
                                    break;
                                }
                                case 3: {
                                    c = (char)(c * 10);
                                    c = (char)(c + (char)(c3 - 48));
                                    if (n2 != 3) break;
                                    c2 = '\u0000';
                                    break;
                                }
                                case 4: {
                                    c = (char)(c * 16);
                                    c = (char)(c + CsvReader.hexToDec(c3));
                                    if (n2 != 2) break;
                                    c2 = '\u0000';
                                }
                            }
                            if (c2 == '\u0000') {
                                this.appendLetter(c);
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            }
                        } else if (this.userSettings.EscapeMode == 2 && bl) {
                            switch (c3) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    n3 = 2;
                                    c2 = '\u0001';
                                    n2 = 1;
                                    c = (char)(c3 - 48);
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (c3) {
                                        case 'U': 
                                        case 'u': {
                                            n3 = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            n3 = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            n3 = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            n3 = 3;
                                        }
                                    }
                                    c2 = '\u0001';
                                    n2 = 0;
                                    c = '\u0000';
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                            }
                            bl = false;
                        } else if (c3 == this.userSettings.Delimiter) {
                            this.endColumn();
                        } else if (!this.useCustomRecordDelimiter && (c3 == '\r' || c3 == '\n') || this.useCustomRecordDelimiter && c3 == this.userSettings.RecordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = c3;
                        n = 0;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.Position;
                        if (!this.userSettings.SafetySwitch || this.dataBuffer.Position - this.dataBuffer.ColumnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false" + " if you're expecting column lengths greater than 100,000 characters to" + " avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.Position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || this.lastLetter == this.userSettings.Delimiter) {
                this.endColumn();
                this.endRecord();
            }
        }
        this.rawRecord = this.userSettings.CaptureRawRecord ? (this.hasMoreData ? (this.rawBuffer.Position == 0 ? new String(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.dataBuffer.Position - this.dataBuffer.LineStart - 1) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position) + new String(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.dataBuffer.Position - this.dataBuffer.LineStart - 1)) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position)) : "";
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        if (!this.initialized) {
            if (this.fileName != null) {
                this.inputStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.charset), 4096);
            }
            this.charset = null;
            this.initialized = true;
        }
        this.updateCurrentValue();
        if (this.userSettings.CaptureRawRecord && this.dataBuffer.Count > 0) {
            if (this.rawBuffer.Buffer.length - this.rawBuffer.Position < this.dataBuffer.Count - this.dataBuffer.LineStart) {
                int n = this.rawBuffer.Buffer.length + Math.max(this.dataBuffer.Count - this.dataBuffer.LineStart, this.rawBuffer.Buffer.length);
                char[] cArray = new char[n];
                System.arraycopy(this.rawBuffer.Buffer, 0, cArray, 0, this.rawBuffer.Position);
                this.rawBuffer.Buffer = cArray;
            }
            System.arraycopy(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.rawBuffer.Buffer, this.rawBuffer.Position, this.dataBuffer.Count - this.dataBuffer.LineStart);
            this.rawBuffer.Position += this.dataBuffer.Count - this.dataBuffer.LineStart;
        }
        try {
            this.dataBuffer.Count = this.inputStream.read(this.dataBuffer.Buffer, 0, this.dataBuffer.Buffer.length);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (this.dataBuffer.Count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.Position = 0;
        this.dataBuffer.LineStart = 0;
        this.dataBuffer.ColumnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean bl = this.readRecord();
        this.headersHolder.Length = this.columnsCount;
        this.headersHolder.Headers = new String[this.columnsCount];
        for (int i = 0; i < this.headersHolder.Length; ++i) {
            String string2;
            this.headersHolder.Headers[i] = string2 = this.get(i);
            this.headersHolder.IndexByName.put(string2, new Integer(i));
        }
        if (bl) {
            --this.currentRecord;
        }
        this.columnsCount = 0;
        return bl;
    }

    public String getHeader(int n) throws IOException {
        this.checkClosed();
        if (n > -1 && n < this.headersHolder.Length) {
            return this.headersHolder.Headers[n];
        }
        return "";
    }

    public boolean isQualified(int n) throws IOException {
        this.checkClosed();
        if (n < this.columnsCount && n > -1) {
            return this.isQualified[n];
        }
        return false;
    }

    private void endColumn() throws IOException {
        int n;
        String string2 = "";
        if (this.startedColumn) {
            if (this.columnBuffer.Position == 0) {
                if (this.dataBuffer.ColumnStart < this.dataBuffer.Position) {
                    if (this.userSettings.TrimWhitespace && !this.startedWithQualifier) {
                        for (n = this.dataBuffer.Position - 1; n >= this.dataBuffer.ColumnStart && (this.dataBuffer.Buffer[n] == ' ' || this.dataBuffer.Buffer[n] == '\t'); --n) {
                        }
                    }
                    string2 = new String(this.dataBuffer.Buffer, this.dataBuffer.ColumnStart, n - this.dataBuffer.ColumnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this.userSettings.TrimWhitespace && !this.startedWithQualifier) {
                    for (n = this.columnBuffer.Position - 1; n >= 0 && (this.columnBuffer.Buffer[n] == ' ' || this.columnBuffer.Buffer[n] == ' '); --n) {
                    }
                }
                string2 = new String(this.columnBuffer.Buffer, 0, n + 1);
            }
        }
        this.columnBuffer.Position = 0;
        this.startedColumn = false;
        if (this.columnsCount >= 100000 && this.userSettings.SafetySwitch) {
            this.close();
            throw new IOException("Maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false" + " if you're expecting more than 100,000 columns per record to" + " avoid this error.");
        }
        if (this.columnsCount == this.values.length) {
            n = this.values.length * 2;
            String[] stringArray = new String[n];
            System.arraycopy(this.values, 0, stringArray, 0, this.values.length);
            this.values = stringArray;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.isQualified, 0, blArray, 0, this.isQualified.length);
            this.isQualified = blArray;
        }
        this.values[this.columnsCount] = string2;
        this.isQualified[this.columnsCount] = this.startedWithQualifier;
        string2 = "";
        ++this.columnsCount;
    }

    private void appendLetter(char c) {
        if (this.columnBuffer.Position == this.columnBuffer.Buffer.length) {
            int n = this.columnBuffer.Buffer.length * 2;
            char[] cArray = new char[n];
            System.arraycopy(this.columnBuffer.Buffer, 0, cArray, 0, this.columnBuffer.Position);
            this.columnBuffer.Buffer = cArray;
        }
        this.columnBuffer.Buffer[this.columnBuffer.Position++] = c;
        this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.ColumnStart < this.dataBuffer.Position) {
            if (this.columnBuffer.Buffer.length - this.columnBuffer.Position < this.dataBuffer.Position - this.dataBuffer.ColumnStart) {
                int n = this.columnBuffer.Buffer.length + Math.max(this.dataBuffer.Position - this.dataBuffer.ColumnStart, this.columnBuffer.Buffer.length);
                char[] cArray = new char[n];
                System.arraycopy(this.columnBuffer.Buffer, 0, cArray, 0, this.columnBuffer.Position);
                this.columnBuffer.Buffer = cArray;
            }
            System.arraycopy(this.dataBuffer.Buffer, this.dataBuffer.ColumnStart, this.columnBuffer.Buffer, this.columnBuffer.Position, this.dataBuffer.Position - this.dataBuffer.ColumnStart);
            this.columnBuffer.Position += this.dataBuffer.Position - this.dataBuffer.ColumnStart;
        }
        this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
    }

    private void endRecord() throws IOException {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    public int getIndex(String string2) throws IOException {
        this.checkClosed();
        Object v = this.headersHolder.IndexByName.get(string2);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean bl = false;
        if (this.hasMoreData && (bl = this.readRecord())) {
            --this.currentRecord;
        }
        return bl;
    }

    public boolean skipLine() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        boolean bl = false;
        if (this.hasMoreData) {
            boolean bl2 = false;
            do {
                if (this.dataBuffer.Position == this.dataBuffer.Count) {
                    this.checkDataLength();
                    continue;
                }
                bl = true;
                char c = this.dataBuffer.Buffer[this.dataBuffer.Position];
                if (c == '\r' || c == '\n') {
                    bl2 = true;
                }
                this.lastLetter = c;
                if (bl2) continue;
                ++this.dataBuffer.Position;
            } while (this.hasMoreData && !bl2);
            this.columnBuffer.Position = 0;
            this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
        }
        this.rawBuffer.Position = 0;
        this.rawRecord = "";
        return bl;
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    private void close(boolean bl) {
        if (!this.closed) {
            if (bl) {
                this.charset = null;
                this.headersHolder.Headers = null;
                this.headersHolder.IndexByName = null;
                this.dataBuffer.Buffer = null;
                this.columnBuffer.Buffer = null;
                this.rawBuffer.Buffer = null;
            }
            try {
                if (this.initialized) {
                    this.inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
            this.closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("This instance of the CsvReader class has already been closed.");
        }
    }

    protected void finalize() {
        this.close(false);
    }

    private static char hexToDec(char c) {
        char c2 = c >= 'a' ? (char)(c - 97 + 10) : (c >= 'A' ? (char)(c - 65 + 10) : (char)(c - 48));
        return c2;
    }

    private class StaticSettings {
        public static final int MAX_BUFFER_SIZE = 1024;
        public static final int MAX_FILE_BUFFER_SIZE = 4096;
        public static final int INITIAL_COLUMN_COUNT = 10;
        public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;

        private StaticSettings() {
        }
    }

    private class HeadersHolder {
        public String[] Headers = null;
        public int Length = 0;
        public HashMap IndexByName = new HashMap();
    }

    private class UserSettings {
        public boolean CaseSensitive = true;
        public char TextQualifier = (char)34;
        public boolean TrimWhitespace = true;
        public boolean UseTextQualifier = true;
        public char Delimiter = (char)44;
        public char RecordDelimiter = '\u0000';
        public char Comment = (char)35;
        public boolean UseComments = false;
        public int EscapeMode = 1;
        public boolean SafetySwitch = true;
        public boolean SkipEmptyRecords = true;
        public boolean CaptureRawRecord = true;
    }

    private class Letters {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char QUOTE = '\"';
        public static final char COMMA = ',';
        public static final char SPACE = ' ';
        public static final char TAB = '\t';
        public static final char POUND = '#';
        public static final char BACKSLASH = '\\';
        public static final char NULL = '\u0000';
        public static final char BACKSPACE = '\b';
        public static final char FORM_FEED = '\f';
        public static final char ESCAPE = '\u001b';
        public static final char VERTICAL_TAB = '\u000b';
        public static final char ALERT = '\u0007';

        private Letters() {
        }
    }

    private class RawRecordBuffer {
        public char[] Buffer = new char[500];
        public int Position = 0;
    }

    private class ColumnBuffer {
        public char[] Buffer = new char[50];
        public int Position = 0;
    }

    private class DataBuffer {
        public char[] Buffer = new char[1024];
        public int Position = 0;
        public int Count = 0;
        public int ColumnStart = 0;
        public int LineStart = 0;
    }

    private class ComplexEscape {
        private static final int UNICODE = 1;
        private static final int OCTAL = 2;
        private static final int DECIMAL = 3;
        private static final int HEX = 4;

        private ComplexEscape() {
        }
    }
}

