/*
 * Decompiled with CFR 0.152.
 */
package com.csvreader;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class CsvWriter {
    private PrintWriter outputStream = null;
    private String fileName = null;
    private boolean firstColumn = true;
    private boolean useCustomRecordDelimiter = false;
    private Charset charset = null;
    private UserSettings userSettings = new UserSettings();
    private boolean initialized = false;
    private boolean closed = false;
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;

    public CsvWriter(String string2, char c, Charset charset) {
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset can not be null.");
        }
        this.fileName = string2;
        this.userSettings.Delimiter = c;
        this.charset = charset;
    }

    public CsvWriter(String string2) {
        this(string2, ',', Charset.forName("ISO-8859-1"));
    }

    public CsvWriter(Writer writer, char c) {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter outputStream can not be null.");
        }
        this.outputStream = new PrintWriter(writer);
        this.userSettings.Delimiter = c;
        this.initialized = true;
    }

    public CsvWriter(OutputStream outputStream, char c, Charset charset) {
        this(new OutputStreamWriter(outputStream, charset), c);
    }

    public char getDelimiter() {
        return this.userSettings.Delimiter;
    }

    public void setDelimiter(char c) {
        this.userSettings.Delimiter = c;
    }

    public char getRecordDelimiter() {
        return this.userSettings.RecordDelimiter;
    }

    public void setRecordDelimiter(char c) {
        this.useCustomRecordDelimiter = true;
        this.userSettings.RecordDelimiter = c;
    }

    public char getTextQualifier() {
        return this.userSettings.TextQualifier;
    }

    public void setTextQualifier(char c) {
        this.userSettings.TextQualifier = c;
    }

    public boolean getUseTextQualifier() {
        return this.userSettings.UseTextQualifier;
    }

    public void setUseTextQualifier(boolean bl) {
        this.userSettings.UseTextQualifier = bl;
    }

    public int getEscapeMode() {
        return this.userSettings.EscapeMode;
    }

    public void setEscapeMode(int n) {
        this.userSettings.EscapeMode = n;
    }

    public void setComment(char c) {
        this.userSettings.Comment = c;
    }

    public char getComment() {
        return this.userSettings.Comment;
    }

    public boolean getForceQualifier() {
        return this.userSettings.ForceQualifier;
    }

    public void setForceQualifier(boolean bl) {
        this.userSettings.ForceQualifier = bl;
    }

    public void write(String string2, boolean bl) throws IOException {
        this.checkClosed();
        this.checkInit();
        if (string2 == null) {
            string2 = "";
        }
        if (!this.firstColumn) {
            this.outputStream.write(this.userSettings.Delimiter);
        }
        boolean bl2 = this.userSettings.ForceQualifier;
        if (!bl && string2.length() > 0) {
            string2 = string2.trim();
        }
        if (!bl2 && this.userSettings.UseTextQualifier && (string2.indexOf(this.userSettings.TextQualifier) > -1 || string2.indexOf(this.userSettings.Delimiter) > -1 || !this.useCustomRecordDelimiter && (string2.indexOf(10) > -1 || string2.indexOf(13) > -1) || this.useCustomRecordDelimiter && string2.indexOf(this.userSettings.RecordDelimiter) > -1 || this.firstColumn && string2.length() > 0 && string2.charAt(0) == this.userSettings.Comment || this.firstColumn && string2.length() == 0)) {
            bl2 = true;
        }
        if (this.userSettings.UseTextQualifier && !bl2 && string2.length() > 0 && bl) {
            char c;
            char c2 = string2.charAt(0);
            if (c2 == ' ' || c2 == '\t') {
                bl2 = true;
            }
            if (!(bl2 || string2.length() <= 1 || (c = string2.charAt(string2.length() - 1)) != ' ' && c != '\t')) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.outputStream.write(this.userSettings.TextQualifier);
            if (this.userSettings.EscapeMode == 2) {
                string2 = CsvWriter.replace(string2, "\\", "\\\\");
                string2 = CsvWriter.replace(string2, "" + this.userSettings.TextQualifier, "\\" + this.userSettings.TextQualifier);
            } else {
                string2 = CsvWriter.replace(string2, "" + this.userSettings.TextQualifier, "" + this.userSettings.TextQualifier + this.userSettings.TextQualifier);
            }
        } else if (this.userSettings.EscapeMode == 2) {
            string2 = CsvWriter.replace(string2, "\\", "\\\\");
            string2 = CsvWriter.replace(string2, "" + this.userSettings.Delimiter, "\\" + this.userSettings.Delimiter);
            if (this.useCustomRecordDelimiter) {
                string2 = CsvWriter.replace(string2, "" + this.userSettings.RecordDelimiter, "\\" + this.userSettings.RecordDelimiter);
            } else {
                string2 = CsvWriter.replace(string2, "\r", "\\\r");
                string2 = CsvWriter.replace(string2, "\n", "\\\n");
            }
            if (this.firstColumn && string2.length() > 0 && string2.charAt(0) == this.userSettings.Comment) {
                string2 = string2.length() > 1 ? "\\" + this.userSettings.Comment + string2.substring(1) : "\\" + this.userSettings.Comment;
            }
        }
        this.outputStream.write(string2);
        if (bl2) {
            this.outputStream.write(this.userSettings.TextQualifier);
        }
        this.firstColumn = false;
    }

    public void write(String string2) throws IOException {
        this.write(string2, false);
    }

    public void writeComment(String string2) throws IOException {
        this.checkClosed();
        this.checkInit();
        this.outputStream.write(this.userSettings.Comment);
        this.outputStream.write(string2);
        if (this.useCustomRecordDelimiter) {
            this.outputStream.write(this.userSettings.RecordDelimiter);
        } else {
            this.outputStream.println();
        }
        this.firstColumn = true;
    }

    public void writeRecord(String[] stringArray, boolean bl) throws IOException {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.write(stringArray[i], bl);
            }
            this.endRecord();
        }
    }

    public void writeRecord(String[] stringArray) throws IOException {
        this.writeRecord(stringArray, false);
    }

    public void endRecord() throws IOException {
        this.checkClosed();
        this.checkInit();
        if (this.useCustomRecordDelimiter) {
            this.outputStream.write(this.userSettings.RecordDelimiter);
        } else {
            this.outputStream.println();
        }
        this.firstColumn = true;
    }

    private void checkInit() throws IOException {
        if (!this.initialized) {
            if (this.fileName != null) {
                this.outputStream = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.charset));
            }
            this.initialized = true;
        }
    }

    public void flush() {
        this.outputStream.flush();
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    private void close(boolean bl) {
        if (!this.closed) {
            if (bl) {
                this.charset = null;
            }
            try {
                if (this.initialized) {
                    this.outputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputStream = null;
            this.closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("This instance of the CsvWriter class has already been closed.");
        }
    }

    protected void finalize() {
        this.close(false);
    }

    public static String replace(String string2, String string3, String string4) {
        int n = string3.length();
        int n2 = string2.indexOf(string3);
        if (n2 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n2 != -1) {
                stringBuffer.append(string2.substring(n3, n2));
                stringBuffer.append(string4);
                n3 = n2 + n;
                n2 = string2.indexOf(string3, n3);
            }
            stringBuffer.append(string2.substring(n3));
            return stringBuffer.toString();
        }
        return string2;
    }

    private class UserSettings {
        public char TextQualifier = (char)34;
        public boolean UseTextQualifier = true;
        public char Delimiter = (char)44;
        public char RecordDelimiter = '\u0000';
        public char Comment = (char)35;
        public int EscapeMode = 1;
        public boolean ForceQualifier = false;
    }

    private class Letters {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char QUOTE = '\"';
        public static final char COMMA = ',';
        public static final char SPACE = ' ';
        public static final char TAB = '\t';
        public static final char POUND = '#';
        public static final char BACKSLASH = '\\';
        public static final char NULL = '\u0000';

        private Letters() {
        }
    }
}

