/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteString {
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private volatile int hash = 0;

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size2) {
        byte[] copy = new byte[size2];
        System.arraycopy(bytes, offset, copy, 0, size2);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(ByteBuffer bytes, int size2) {
        byte[] copy = new byte[size2];
        bytes.get(copy);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        return ByteString.copyFrom(bytes, bytes.remaining());
    }

    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return new ByteString(text.getBytes(charsetName));
    }

    public static ByteString copyFromUtf8(String text) {
        try {
            return new ByteString(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public static ByteString copyFrom(List<ByteString> list) {
        if (list.size() == 0) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int size2 = 0;
        for (ByteString str : list) {
            size2 += str.size();
        }
        byte[] bytes = new byte[size2];
        int pos = 0;
        for (ByteString str : list) {
            System.arraycopy(str.bytes, 0, bytes, pos, str.size());
            pos += str.size();
        }
        return new ByteString(bytes);
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int size2) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, size2);
    }

    public void copyTo(ByteBuffer target) {
        target.put(this.bytes, 0, this.bytes.length);
    }

    public byte[] toByteArray() {
        int size2 = this.bytes.length;
        byte[] copy = new byte[size2];
        System.arraycopy(this.bytes, 0, copy, 0, size2);
        return copy;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.bytes, charsetName);
    }

    public String toStringUtf8() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)o;
        int size2 = this.bytes.length;
        if (size2 != other.bytes.length) {
            return false;
        }
        byte[] thisBytes = this.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size2; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            int size2;
            byte[] thisBytes = this.bytes;
            h2 = size2 = this.bytes.length;
            for (int i = 0; i < size2; ++i) {
                h2 = h2 * 31 + thisBytes[i];
            }
            if (h2 == 0) {
                h2 = 1;
            }
            this.hash = h2;
        }
        return h2;
    }

    public InputStream newInput() {
        return new ByteArrayInputStream(this.bytes);
    }

    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes);
    }

    public static Output newOutput(int initialCapacity) {
        return new Output(new ByteArrayOutputStream(initialCapacity));
    }

    public static Output newOutput() {
        return ByteString.newOutput(32);
    }

    static CodedBuilder newCodedBuilder(int size2) {
        return new CodedBuilder(size2);
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int size2) {
            this.buffer = new byte[size2];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new ByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends FilterOutputStream {
        private final ByteArrayOutputStream bout;

        private Output(ByteArrayOutputStream bout) {
            super(bout);
            this.bout = bout;
        }

        public ByteString toByteString() {
            byte[] byteArray = this.bout.toByteArray();
            return new ByteString(byteArray);
        }
    }
}

