/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.util;

import com.aliyun.odps.Odps;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.tunnel.TableTunnel;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.config.MaxcomputeConfig;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.exception.MaxcomputeConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxcomputeUtil {
    private static final Logger log = LoggerFactory.getLogger(MaxcomputeUtil.class);

    public static Table getTable(Config pluginConfig) {
        Odps odps = MaxcomputeUtil.getOdps(pluginConfig);
        Table table = odps.tables().get(pluginConfig.getString(MaxcomputeConfig.TABLE_NAME.key()));
        return table;
    }

    public static TableTunnel getTableTunnel(Config pluginConfig) {
        Odps odps = MaxcomputeUtil.getOdps(pluginConfig);
        TableTunnel tunnel = new TableTunnel(odps);
        return tunnel;
    }

    public static Odps getOdps(Config pluginConfig) {
        AliyunAccount account = new AliyunAccount(pluginConfig.getString(MaxcomputeConfig.ACCESS_ID.key()), pluginConfig.getString(MaxcomputeConfig.ACCESS_KEY.key()));
        Odps odps = new Odps(account);
        odps.setEndpoint(pluginConfig.getString(MaxcomputeConfig.ENDPOINT.key()));
        odps.setDefaultProject(pluginConfig.getString(MaxcomputeConfig.PROJECT.key()));
        return odps;
    }

    public static TableTunnel.DownloadSession getDownloadSession(Config pluginConfig) {
        TableTunnel.DownloadSession session;
        TableTunnel tunnel = MaxcomputeUtil.getTableTunnel(pluginConfig);
        try {
            if (pluginConfig.hasPath(MaxcomputeConfig.PARTITION_SPEC.key())) {
                PartitionSpec partitionSpec = new PartitionSpec(pluginConfig.getString(MaxcomputeConfig.PARTITION_SPEC.key()));
                session = tunnel.createDownloadSession(pluginConfig.getString(MaxcomputeConfig.PROJECT.key()), pluginConfig.getString(MaxcomputeConfig.TABLE_NAME.key()), partitionSpec);
            } else {
                session = tunnel.createDownloadSession(pluginConfig.getString(MaxcomputeConfig.PROJECT.key()), pluginConfig.getString(MaxcomputeConfig.TABLE_NAME.key()));
            }
        }
        catch (Exception e) {
            throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.READER_OPERATION_FAILED, (Throwable)e);
        }
        return session;
    }

    public static void initTableOrPartition(Config pluginConfig) {
        block10: {
            Boolean overwrite = (Boolean)MaxcomputeConfig.OVERWRITE.defaultValue();
            if (pluginConfig.hasPath(MaxcomputeConfig.OVERWRITE.key())) {
                overwrite = pluginConfig.getBoolean(MaxcomputeConfig.OVERWRITE.key());
            }
            try {
                Table table = MaxcomputeUtil.getTable(pluginConfig);
                if (pluginConfig.hasPath(MaxcomputeConfig.PARTITION_SPEC.key())) {
                    PartitionSpec partitionSpec = new PartitionSpec(pluginConfig.getString(MaxcomputeConfig.PARTITION_SPEC.key()));
                    if (overwrite.booleanValue()) {
                        try {
                            table.deletePartition(partitionSpec, true);
                        }
                        catch (NullPointerException e) {
                            log.debug("NullPointerException when delete table partition");
                        }
                    }
                    table.createPartition(partitionSpec, true);
                    break block10;
                }
                if (overwrite.booleanValue()) {
                    try {
                        table.truncate();
                    }
                    catch (NullPointerException e) {
                        log.debug("NullPointerException when truncate table");
                    }
                }
            }
            catch (Exception e) {
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCode.READER_OPERATION_FAILED, (Throwable)e);
            }
        }
    }
}

