/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.SessionQueryResult;
import com.aliyun.odps.task.SQLRTTask;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Session {
    private static String DEFAULT_TASK_NAME = "console_sqlrt_task";
    private static final long POLL_INTERVAL = TimeUnit.SECONDS.toMillis(3L);
    private String sessionName;
    private Instance instance;
    private String logView;
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static int OBJECT_STATUS_RUNNING = 2;
    private static int OBJECT_STATUS_FAILED = 4;
    private static int OBJECT_STATUS_TERMINATED = 5;
    private static int OBJECT_STATUS_CANCELLED = 6;

    public Session(Odps odps, Instance instance) throws OdpsException {
        this(odps, instance, null);
    }

    Session(Odps odps, Instance instance, String sessionName) throws OdpsException {
        this.sessionName = sessionName;
        this.instance = instance;
        this.logView = new LogView(odps).generateLogView(instance, 168L);
    }

    public String getLogView() {
        return this.logView;
    }

    public void setLogView(String logView) {
        this.logView = logView;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static Session attach(Odps odps, String sessionName) throws OdpsException {
        return Session.attach(odps, sessionName, null);
    }

    public static Session attach(Odps odps, String sessionName, Map<String, String> hints) throws OdpsException {
        return Session.attach(odps, sessionName, hints, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session attach(Odps odps, String sessionName, Map<String, String> hints, Long timeout) throws OdpsException {
        if (StringUtils.isNullOrEmpty(sessionName)) {
            throw new IllegalArgumentException("Session name can not be empty.");
        }
        if (hints == null) {
            hints = new HashMap<String, String>();
        }
        hints.put("odps.sql.session.share.id", sessionName);
        try {
            Session session = Session.createInternal(odps, null, null, null, null, null, hints, timeout);
            return session;
        }
        finally {
            hints.remove("odps.sql.session.share.id");
        }
    }

    public static Session create(Odps odps, int workerCount, int workerMemory) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, null, null, null, null, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, sessionName, null, null, null, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName, String projectName, String workerSpareSpan, Map<String, String> hints, Long timeout) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, workerCount, workerMemory, workerSpareSpan, hints, timeout);
    }

    public static Session create(Odps odps, String sessionName, String projectName, Map<String, String> hints, Long timeout) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, null, null, null, hints, timeout);
    }

    public SessionQueryResult run(String sql) throws OdpsException {
        return this.run(sql, null);
    }

    public SessionQueryResult run(String sql, Map<String, String> hints) throws OdpsException {
        JsonObject request = new JsonObject();
        request.add("query", new JsonPrimitive(sql));
        if (hints == null) {
            hints = new HashMap<String, String>();
        }
        JsonObject settings = new JsonObject();
        for (Map.Entry<String, String> property : hints.entrySet()) {
            settings.addProperty(property.getKey(), property.getValue());
        }
        request.add("settings", settings);
        this.instance.setTaskInfo(DEFAULT_TASK_NAME, "query", gson.toJson(request));
        return new SessionQueryResult((Iterator<SubQueryResponse>)new ListIterator<SubQueryResponse>(){
            boolean queryTerminated = false;

            @Override
            protected List<SubQueryResponse> list() {
                try {
                    SubQueryResponse response;
                    if (this.queryTerminated) {
                        return null;
                    }
                    while ((response = Session.this.getResponse(Session.this.instance.getTaskInfo(DEFAULT_TASK_NAME, "result"))) == null || response.status == null) {
                        Session.this.checkTaskStatus();
                    }
                    if (response.status != OBJECT_STATUS_RUNNING) {
                        this.queryTerminated = true;
                    }
                    return Arrays.asList(response);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }

    public void stop() throws OdpsException {
        this.instance.stop();
    }

    public void waitForStart() throws OdpsException {
        this.waitForStart(0L);
    }

    public void waitForStart(long timeout) throws OdpsException {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        if (timeout > 0L) {
            endTime += startTime + TimeUnit.SECONDS.toMillis(timeout);
        }
        while (0L == endTime || System.currentTimeMillis() < endTime) {
            SubQueryResponse response = this.getResponse(this.instance.getTaskInfo(DEFAULT_TASK_NAME, "status"));
            if (response == null || response.status == null) {
                this.checkTaskStatus();
            } else {
                if (response.status == OBJECT_STATUS_RUNNING) {
                    return;
                }
                if (response.status == OBJECT_STATUS_FAILED) {
                    throw new OdpsException(String.format("Start session[%s] failed: %s ", this.sessionName, response.result));
                }
            }
            this.sleep();
        }
    }

    private SubQueryResponse getResponse(String result) {
        if (StringUtils.isNullOrEmpty(result)) {
            return null;
        }
        return gson.fromJson(result, SubQueryResponse.class);
    }

    private void checkTaskStatus() throws OdpsException {
        Instance.TaskStatus status = this.instance.getTaskStatus().get(DEFAULT_TASK_NAME);
        if (status != null && status.getStatus() != Instance.TaskStatus.Status.RUNNING) {
            throw new OdpsException(String.format("Session[%s] is %s: %s", this.instance.getId(), status.getStatus().toString(), this.instance.getTaskResults().get(DEFAULT_TASK_NAME)));
        }
    }

    private static Session createInternal(Odps odps, String projectName, String sessionName, Integer workerCount, Integer workerMemory, String workerSpareSpan, Map<String, String> hints, Long timeout) throws OdpsException {
        if (projectName != null && projectName.trim().isEmpty()) {
            throw new IllegalArgumentException("Project name can not be empty.");
        }
        if (null == hints) {
            hints = new HashMap<String, String>();
        }
        String string = projectName = projectName == null ? odps.getDefaultProject() : projectName;
        if (!StringUtils.isNullOrEmpty(workerSpareSpan)) {
            hints.put("odps.sql.session.worker.sparespan", workerSpareSpan);
        }
        if (!StringUtils.isNullOrEmpty(sessionName)) {
            hints.put("odps.sql.session.name", sessionName.trim());
        }
        if (null != workerCount) {
            hints.put("odps.sql.session.worker.count", workerCount.toString());
        }
        if (null != workerMemory) {
            hints.put("odps.sql.session.worker.memory", workerMemory.toString());
        }
        String userSubmitMode = hints.get("odps.sql.submit.mode");
        hints.put("odps.sql.submit.mode", "script");
        SQLRTTask task = new SQLRTTask();
        task.setName(DEFAULT_TASK_NAME);
        try {
            String json = gson.toJson(hints);
            task.setProperty("settings", json);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        Instance instance = odps.instances().create(projectName, task);
        if (userSubmitMode == null || userSubmitMode.isEmpty()) {
            hints.remove("odps.sql.submit.mode");
        } else {
            hints.put("odps.sql.submit.mode", userSubmitMode);
        }
        Session session = new Session(odps, instance, sessionName);
        session.printLogView();
        if (timeout != null) {
            session.waitForStart(timeout);
        }
        return session;
    }

    public void printLogView() {
        System.out.println("");
        System.err.println("ID = " + this.instance.getId());
        System.err.println("Log view:");
        System.err.println(this.logView);
    }

    private void sleep() throws OdpsException {
        try {
            Thread.sleep(POLL_INTERVAL);
        }
        catch (InterruptedException e) {
            throw new OdpsException("Interrupted while sleep.", e);
        }
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public class SubQueryResponse {
        public Integer status;
        public String result;
        public String warnings;
        public Integer subQueryId;
    }
}

