/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.google.gson.GsonBuilder;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="MOYE")
public class MoyeTask
extends Task {
    private String Plan;

    public String getPlan() {
        return this.Plan;
    }

    @XmlElement(name="Plan")
    public void setPlan(String plan) {
        this.Plan = plan;
    }

    static MoyeTask GetMoyeTask(String plan, String taskName, Map<String, String> hints) throws OdpsException {
        MoyeTask task = new MoyeTask();
        task.setName(taskName);
        task.setPlan(plan);
        task.setProperty("type", "moye");
        if (hints != null) {
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return task;
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints, int priority) throws OdpsException {
        MoyeTask task = MoyeTask.GetMoyeTask(plan, "no_use", hints);
        return odps.instances().create(project, task, priority);
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints) throws OdpsException {
        MoyeTask task = MoyeTask.GetMoyeTask(plan, "no_use", hints);
        return odps.instances().create(project, task);
    }
}

