/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.GeneralConfiguration;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.net.URI;
import java.net.URISyntaxException;

class Configuration
extends GeneralConfiguration {
    private CompressOption option = new CompressOption();

    public Configuration(Odps odps) {
        super(odps);
    }

    public CompressOption getCompressOption() {
        return this.option;
    }

    public void setCompressOption(CompressOption option) {
        this.option = option;
    }

    @Override
    public URI getEndpoint(String projectName) throws TunnelException {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        URI u = null;
        try {
            u = new URI(this.odps.projects().get(projectName).getTunnelEndpoint());
        }
        catch (URISyntaxException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return u;
    }

    @Deprecated
    public String getStreamUploadResource(String projectName, String tableName, String shardId) {
        StringBuilder sb = new StringBuilder();
        sb.append("/projects/").append(projectName).append("/tables/").append(tableName).append("/shards/").append(shardId);
        return sb.toString();
    }

    RestClient newRestClient(String projectName) throws TunnelException {
        RestClient odpsServiceClient = this.odps.clone().getRestClient();
        odpsServiceClient.setReadTimeout(this.getSocketTimeout());
        odpsServiceClient.setConnectTimeout(this.getSocketConnectTimeout());
        odpsServiceClient.setEndpoint(this.getEndpoint(projectName).toString());
        return odpsServiceClient;
    }
}

