/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.sink;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import java.io.IOException;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.config.MaxcomputeConfig;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.exception.MaxcomputeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.util.MaxcomputeTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.util.MaxcomputeUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxcomputeWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(MaxcomputeWriter.class);
    private RecordWriter recordWriter;
    private final TableTunnel.UploadSession session;
    private final TableSchema tableSchema;
    private static final Long BLOCK_0 = 0L;
    private SeaTunnelRowType rowType;

    public MaxcomputeWriter(Config pluginConfig, SeaTunnelRowType rowType) {
        try {
            this.rowType = rowType;
            Table table = MaxcomputeUtil.getTable(pluginConfig);
            this.tableSchema = table.getSchema();
            TableTunnel tunnel = MaxcomputeUtil.getTableTunnel(pluginConfig);
            if (pluginConfig.hasPath(MaxcomputeConfig.PARTITION_SPEC.key())) {
                PartitionSpec partitionSpec = new PartitionSpec(pluginConfig.getString(MaxcomputeConfig.PARTITION_SPEC.key()));
                this.session = tunnel.createUploadSession(pluginConfig.getString(MaxcomputeConfig.PROJECT.key()), pluginConfig.getString(MaxcomputeConfig.TABLE_NAME.key()), partitionSpec);
            } else {
                this.session = tunnel.createUploadSession(pluginConfig.getString(MaxcomputeConfig.PROJECT.key()), pluginConfig.getString(MaxcomputeConfig.TABLE_NAME.key()));
            }
            this.recordWriter = this.session.openRecordWriter(BLOCK_0);
            log.info("open record writer success");
        }
        catch (Exception e) {
            throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, (Throwable)e);
        }
    }

    public void write(SeaTunnelRow seaTunnelRow) throws IOException {
        Record record = MaxcomputeTypeMapper.getMaxcomputeRowData(seaTunnelRow, this.tableSchema, this.rowType);
        this.recordWriter.write(record);
    }

    public void close() throws IOException {
        if (this.recordWriter != null) {
            this.recordWriter.close();
            try {
                this.session.commit(new Long[]{BLOCK_0});
            }
            catch (Exception e) {
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, (Throwable)e);
            }
            this.recordWriter = null;
        }
    }
}

