/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.util;

import com.aliyun.odps.Column;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.catalog.MaxComputeDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.exception.MaxcomputeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.util.MaxcomputeUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxcomputeTypeMapper
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MaxcomputeTypeMapper.class);

    public static SeaTunnelRow getSeaTunnelRowData(Record rs, SeaTunnelRowType typeInfo) {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (int i = 0; i < typeInfo.getTotalFields(); ++i) {
            String typeName = typeInfo.getFieldName(i);
            fields.add(MaxcomputeTypeMapper.resolveObject2SeaTunnel(rs.get(typeName), typeInfo.getFieldType(i)));
        }
        return new SeaTunnelRow(fields.toArray());
    }

    public static Record getMaxcomputeRowData(SeaTunnelRow seaTunnelRow, TableSchema tableSchema, SeaTunnelRowType rowType) {
        ArrayRecord arrayRecord = new ArrayRecord(tableSchema);
        for (int i = 0; i < seaTunnelRow.getFields().length; ++i) {
            String fieldName = rowType.getFieldName(i);
            if (!tableSchema.containsColumn(fieldName)) {
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("field not found in written table: %s,rowType: %s", fieldName, seaTunnelRow.getField(i)));
            }
            Column column = tableSchema.getColumn(fieldName);
            arrayRecord.set(tableSchema.getColumnIndex(fieldName), MaxcomputeTypeMapper.resolveObject2Maxcompute(seaTunnelRow.getField(i), column.getTypeInfo()));
        }
        return arrayRecord;
    }

    public static SeaTunnelRowType getSeaTunnelRowType(Config pluginConfig) {
        Table table = MaxcomputeUtil.getTable(pluginConfig);
        TableSchema tableSchema = table.getSchema();
        ArrayList seaTunnelDataTypes = new ArrayList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            MaxComputeDataTypeConvertor typeConvertor = new MaxComputeDataTypeConvertor();
            for (int i = 0; i < tableSchema.getColumns().size(); ++i) {
                String fieldName = tableSchema.getColumns().get(i).getName();
                fieldNames.add(fieldName);
                TypeInfo maxcomputeTypeInfo = tableSchema.getColumns().get(i).getTypeInfo();
                SeaTunnelDataType<?> seaTunnelDataType = typeConvertor.toSeaTunnelType(fieldName, maxcomputeTypeInfo, null);
                seaTunnelDataTypes.add(seaTunnelDataType);
            }
        }
        catch (Exception e) {
            throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, (Throwable)e);
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[fieldNames.size()]), seaTunnelDataTypes.toArray(new SeaTunnelDataType[seaTunnelDataTypes.size()]));
    }

    private static Object resolveObject2SeaTunnel(Object field2, SeaTunnelDataType<?> fieldType) {
        if (field2 == null) {
            return null;
        }
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                ArrayList origArray = new ArrayList();
                ((ArrayList)field2).iterator().forEachRemaining(origArray::add);
                SeaTunnelDataType elementType = ((ArrayType)fieldType).getElementType();
                switch (elementType.getSqlType()) {
                    case STRING: {
                        return origArray.toArray(new String[0]);
                    }
                    case BOOLEAN: {
                        return origArray.toArray(new Boolean[0]);
                    }
                    case INT: {
                        return origArray.toArray(new Integer[0]);
                    }
                    case BIGINT: {
                        return origArray.toArray(new Long[0]);
                    }
                    case FLOAT: {
                        return origArray.toArray(new Float[0]);
                    }
                    case DOUBLE: {
                        return origArray.toArray(new Double[0]);
                    }
                }
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", fieldType.getSqlType().name()));
            }
            case MAP: {
                HashMap dataMap = new HashMap();
                SeaTunnelDataType keyType = ((MapType)fieldType).getKeyType();
                SeaTunnelDataType valueType = ((MapType)fieldType).getValueType();
                HashMap origDataMap = (HashMap)field2;
                origDataMap.forEach((key, value) -> dataMap.put(MaxcomputeTypeMapper.resolveObject2SeaTunnel(key, keyType), MaxcomputeTypeMapper.resolveObject2SeaTunnel(value, valueType)));
                return dataMap;
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)fieldType).getFieldTypes();
                Object[] objects = new Object[fieldTypes.length];
                List<Object> fieldValues = ((SimpleStruct)field2).getFieldValues();
                for (int i = 0; i < fieldTypes.length; ++i) {
                    Object object;
                    objects[i] = object = MaxcomputeTypeMapper.resolveObject2SeaTunnel(fieldValues.get(i), fieldTypes[i]);
                }
                return new SeaTunnelRow(objects);
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case TINYINT: 
            case SMALLINT: 
            case DECIMAL: {
                return field2;
            }
            case BYTES: {
                return ((Binary)field2).data();
            }
            case STRING: {
                if (field2 instanceof byte[]) {
                    return new String((byte[])field2);
                }
                if (field2 instanceof Char) {
                    return MaxcomputeTypeMapper.rtrim(String.valueOf(field2));
                }
                return String.valueOf(field2);
            }
            case DATE: {
                if (field2 instanceof LocalDate) {
                    return Date.valueOf((LocalDate)field2);
                }
                return ((Date)field2).toLocalDate();
            }
            case TIME: {
                return ((Time)field2).toLocalTime();
            }
            case TIMESTAMP: {
                return ((java.util.Date)field2).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
        }
        throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel type not support this type [%s] now", fieldType.getSqlType().name()));
    }

    private static Object resolveObject2Maxcompute(Object field2, TypeInfo typeInfo) {
        if (field2 == null) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case ARRAY: {
                ArrayList origArray = new ArrayList();
                Arrays.stream((Object[])field2).iterator().forEachRemaining(origArray::add);
                switch (((ArrayTypeInfo)typeInfo).getElementTypeInfo().getOdpsType()) {
                    case STRING: 
                    case BOOLEAN: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: {
                        return origArray;
                    }
                }
                throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Maxcompute type not support this type [%s] now", typeInfo.getTypeName()));
            }
            case MAP: {
                HashMap dataMap = new HashMap();
                TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getKeyTypeInfo();
                TypeInfo valueTypeInfo = ((MapTypeInfo)typeInfo).getValueTypeInfo();
                HashMap origDataMap = (HashMap)field2;
                origDataMap.forEach((key, value) -> dataMap.put(MaxcomputeTypeMapper.resolveObject2Maxcompute(key, keyTypeInfo), MaxcomputeTypeMapper.resolveObject2Maxcompute(value, valueTypeInfo)));
                return origDataMap;
            }
            case STRUCT: {
                Object[] fields = ((SeaTunnelRow)field2).getFields();
                List<TypeInfo> typeInfos = ((StructTypeInfo)typeInfo).getFieldTypeInfos();
                ArrayList<Object> origStruct = new ArrayList<Object>();
                for (int i = 0; i < fields.length; ++i) {
                    origStruct.add(MaxcomputeTypeMapper.resolveObject2Maxcompute(fields[i], typeInfos.get(i)));
                }
                return new SimpleStruct((StructTypeInfo)typeInfo, origStruct);
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case TINYINT: 
            case SMALLINT: {
                return field2;
            }
            case BINARY: {
                return new Binary((byte[])field2);
            }
            case DECIMAL: {
                return null;
            }
            case VARCHAR: {
                return new Varchar((String)field2);
            }
            case CHAR: {
                return new Char((String)field2);
            }
            case STRING: {
                if (field2 instanceof byte[]) {
                    return new String((byte[])field2);
                }
                if (field2 instanceof Char) {
                    return MaxcomputeTypeMapper.rtrim(String.valueOf(field2));
                }
                return String.valueOf(field2);
            }
            case TIMESTAMP: {
                return Timestamp.valueOf((LocalDateTime)field2);
            }
            case DATETIME: {
                return Date.from(((LocalDateTime)field2).atZone(ZoneId.systemDefault()).toInstant());
            }
            case DATE: {
                return Date.valueOf((LocalDate)field2);
            }
        }
        throw new MaxcomputeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Maxcompute type not support this type [%s] now", typeInfo.getTypeName()));
    }

    private static String rtrim(String s2) {
        int i;
        for (i = s2.length() - 1; i >= 0 && Character.isWhitespace(s2.charAt(i)); --i) {
        }
        return s2.substring(0, i + 1);
    }
}

