/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util;

import com.aliyun.odps.commons.util.RetryExceedLimitException;
import com.aliyun.odps.commons.util.backoff.BackOffStrategy;
import com.aliyun.odps.commons.util.backoff.ConstantBackOffStrategy;
import com.aliyun.odps.commons.util.backoff.ExponentialBackOffStrategy;
import com.aliyun.odps.commons.util.backoff.LinearBackOffStrategy;
import com.aliyun.odps.rest.RestClient;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryStrategy {
    private static final Logger LOG = Logger.getLogger(RetryStrategy.class.getName());
    private static final int DEFAULT_ATTEMPTS = 10;
    private static final int DEFAULT_BACKOFF_INTERVAL = 1;
    protected BackOffStrategy strategy;
    protected int attempts;
    protected int limit;
    protected int totalBackoffTime;

    private BackOffStrategy transform(BackoffStrategy strategy, long initInterval) {
        switch (strategy) {
            case CONSTANT_BACKOFF: {
                return new ConstantBackOffStrategy(initInterval);
            }
            case LINEAR_BACKOFF: {
                return new LinearBackOffStrategy(initInterval);
            }
            case EXPONENTIAL_BACKOFF: {
                return new ExponentialBackOffStrategy(initInterval);
            }
        }
        throw new IllegalArgumentException("Invalid retry strategy: " + strategy.name());
    }

    private void init(int limit, BackOffStrategy strategy) {
        if (limit < 0) {
            throw new IllegalArgumentException("Retry limit must >= 0");
        }
        this.limit = limit;
        this.strategy = strategy;
        this.totalBackoffTime = 0;
        this.attempts = 0;
    }

    public RetryStrategy(int limit, BackOffStrategy strategy) {
        this.init(limit, strategy);
    }

    public RetryStrategy(int limit, int interval, BackoffStrategy strategy) {
        this.init(limit, this.transform(strategy, interval));
    }

    public RetryStrategy(int attempts, int interval) {
        this(attempts, interval, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy(int attempts) {
        this(attempts, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy() {
        this(10, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public void reset() {
        this.attempts = 0;
        this.strategy.reset();
    }

    protected boolean needRetry(Exception e) {
        return true;
    }

    public void onFailure(Exception err) throws RetryExceedLimitException {
        this.onFailure(err, null);
    }

    public void onFailure(Exception err, RestClient.RetryLogger logger) throws RetryExceedLimitException {
        if (!this.needRetry(err)) {
            throw new RetryExceedLimitException(0, (Throwable)err);
        }
        if (this.attempts++ >= this.limit) {
            throw new RetryExceedLimitException(this.attempts, (Throwable)err);
        }
        try {
            long millis = this.strategy.next();
            if (logger != null) {
                logger.onRetryLog(err, this.attempts, millis / 1000L);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Start to retry, retryCount: %d, will retry in %d seconds.", this.attempts, millis / 1000L));
            }
            Thread.sleep(millis);
            this.totalBackoffTime = (int)((long)this.totalBackoffTime + millis / 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getTotalBackupTime() {
        return this.totalBackoffTime;
    }

    @Deprecated
    public static enum BackoffStrategy {
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF,
        CONSTANT_BACKOFF;

    }
}

