/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.counter;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Counters
implements Iterable<CounterGroup>,
Writable {
    private Map<Enum<?>, Counter> cache = new IdentityHashMap();
    private TreeMap<String, CounterGroup> groups = new TreeMap();

    public Counters() {
    }

    public Counters(Counters counters) {
    }

    public Counter findCounter(String groupName, String counterName) {
        CounterGroup grp = this.getGroup(groupName);
        return grp.findCounter(counterName);
    }

    public synchronized Counter findCounter(Enum<?> key) {
        Counter counter2 = this.cache.get(key);
        if (counter2 == null) {
            counter2 = this.findCounter(key.getDeclaringClass().getName(), key.toString());
            this.cache.put(key, counter2);
        }
        return counter2;
    }

    public synchronized Collection<String> getGroupNames() {
        return this.groups.keySet();
    }

    @Override
    public Iterator<CounterGroup> iterator() {
        return this.groups.values().iterator();
    }

    public synchronized CounterGroup getGroup(String groupName) {
        CounterGroup grp = this.groups.get(groupName);
        if (grp == null) {
            grp = new CounterGroup(groupName);
            this.groups.put(groupName, grp);
        }
        return grp;
    }

    public synchronized int countCounters() {
        int result = 0;
        for (CounterGroup group : this) {
            result += group.size();
        }
        return result;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("User defined counters: " + this.countCounters());
        for (CounterGroup group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter2 : group) {
                sb.append("\n\t\t" + counter2.getDisplayName() + "=" + counter2.getValue());
            }
        }
        return sb.toString();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Map.Entry<String, CounterGroup> rightEntry : other.groups.entrySet()) {
            CounterGroup left = this.groups.get(rightEntry.getKey());
            CounterGroup right = rightEntry.getValue();
            if (left == null) {
                left = new CounterGroup(right.getName(), right.getDisplayName());
                this.groups.put(rightEntry.getKey(), left);
            }
            left.incrAllCounters(right);
        }
    }

    public boolean equals(Object genericRight) {
        if (genericRight instanceof Counters) {
            Iterator<CounterGroup> right = ((Counters)genericRight).groups.values().iterator();
            Iterator<CounterGroup> left = this.groups.values().iterator();
            while (left.hasNext()) {
                if (right.hasNext() && left.next().equals(right.next())) continue;
                return false;
            }
            return !right.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.groups.size());
        for (CounterGroup group : this.groups.values()) {
            Text.writeString(out, group.getName());
            group.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.cache.clear();
        int numClasses = in.readInt();
        this.groups.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString(in);
            CounterGroup group = new CounterGroup(groupName);
            group.readFields(in);
            this.groups.put(groupName, group);
        }
    }
}

