/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.InputBlobWritable;
import com.aliyun.odps.io.OutputBlobWritable;
import com.aliyun.odps.io.TupleReaderWriter;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.utils.CommonUtils;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Tuple
implements WritableComparable<Object> {
    protected List<Writable> mFields;
    public static final char DELIM = '\u0001';
    public static final String NULLINDICATOR = "\\N";

    public Tuple() {
        this.mFields = new ArrayList<Writable>();
    }

    public Tuple(int size) {
        this.mFields = new ArrayList<Writable>(size);
        for (int i = 0; i < size; ++i) {
            this.mFields.add(null);
        }
    }

    public Tuple(Writable[] fields) {
        this.mFields = new ArrayList<Writable>(fields.length);
        for (Writable field2 : fields) {
            this.mFields.add(field2);
        }
    }

    public Tuple(List<Writable> vals, boolean reference) {
        if (!reference) {
            Tuple temp = new Tuple(vals.toArray(new Writable[vals.size()])).clone();
            this.mFields = temp.mFields;
        } else {
            this.mFields = vals;
        }
    }

    public Tuple(Tuple tuple, boolean reference) {
        this.mFields = !reference ? tuple.clone().mFields : tuple.mFields;
    }

    public int size() {
        return this.mFields.size();
    }

    public Writable get(int fieldNum) {
        return this.mFields.get(fieldNum);
    }

    public List<Writable> getAll() {
        return this.mFields;
    }

    public Writable[] toArray() {
        return this.mFields.toArray(new Writable[this.mFields.size()]);
    }

    public void set(int fieldNum, Writable val) throws IOException {
        this.mFields.set(fieldNum, val);
    }

    public void set(List<Writable> vals) {
        this.mFields = vals;
    }

    public void set(Writable[] vals) {
        this.mFields.clear();
        for (Writable val : vals) {
            this.mFields.add(val);
        }
    }

    public void append(Writable val) {
        this.mFields.add(val);
    }

    public void append(Writable[] vals) {
        for (Writable val : vals) {
            this.mFields.add(val);
        }
    }

    public void append(Collection<Writable> vals) {
        this.mFields.addAll(vals);
    }

    public void clear() {
        this.mFields.clear();
    }

    public String toDelimitedString() {
        return this.toDelimitedString('\u0001', NULLINDICATOR);
    }

    public String toDelimitedString(char delim) {
        return this.toDelimitedString(delim, NULLINDICATOR);
    }

    public String toDelimitedString(char delim, String nullIndicator) {
        return CommonUtils.toDelimitedString(this.mFields.toArray(new Writable[this.mFields.size()]), delim, nullIndicator);
    }

    private String format(Tuple tuple) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < tuple.size(); ++i) {
            Writable d = tuple.get(i);
            if (d != null) {
                if (d instanceof Tuple) {
                    Tuple t = (Tuple)d;
                    sb.append(this.format(t));
                } else {
                    sb.append(d.toString());
                }
            } else {
                sb.append("");
            }
            if (i == tuple.size() - 1) continue;
            sb.append(",");
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return this.format(this);
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof Tuple) {
            Tuple t = (Tuple)other;
            int mySz = this.mFields.size();
            int tSz = t.size();
            if (tSz < mySz) {
                return 1;
            }
            if (tSz > mySz) {
                return -1;
            }
            for (int i = 0; i < mySz; ++i) {
                int c = TupleReaderWriter.compare(this.mFields.get(i), t.get(i));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return TupleReaderWriter.compare(this, (Writable)other);
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int hash = 17;
        for (Writable w : this.mFields) {
            if (w == null) continue;
            hash = 31 * hash + w.hashCode();
        }
        return hash;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        TupleReaderWriter.writeTuple(out, this);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.mFields.clear();
        TupleReaderWriter.readTuple(in, this);
    }

    public Tuple clone() {
        for (Writable field2 : this.mFields) {
            if (!(field2 instanceof InputBlobWritable) && !(field2 instanceof OutputBlobWritable)) continue;
            throw new RuntimeException("ODPS-0730001: Tuple with BlobWritable not support clone");
        }
        Tuple tuple = new Tuple();
        try {
            ReflectionUtils.cloneWritableInto(tuple, this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return tuple;
    }
}

