/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.VolumeException;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class VolumeFSFile
extends LazyLoad
implements Iterable<VolumeFSFile> {
    public static final String DEFAULT_OWNER = "odps";
    public static final String DEFAULT_GROUP = "odps";
    public static final String DEFAULT_DIRECTORY_PERMISSION = "0777";
    private VolumeFSFileModel model;
    private String project;
    private String path;
    private RestClient client;

    protected VolumeFSFile(String project, String path, RestClient client) throws VolumeException {
        VolumeFSFile.checkVolume(path);
        this.project = project;
        this.path = path;
        this.client = client;
    }

    protected VolumeFSFile(VolumeFSFileModel model, String project, String path, RestClient client) {
        this.model = model;
        this.project = project;
        this.path = path;
        this.client = client;
        if (model != null) {
            this.setLoaded(true);
        }
    }

    public static VolumeFSFile getRoot(String project, Odps odps) {
        RestClient client = odps.getRestClient();
        VolumeFSFileModel model = new VolumeFSFileModel();
        model.project = project;
        model.volume = "";
        model.isdir = true;
        model.blockSize = 0L;
        model.blockReplications = 0;
        model.length = 0L;
        model.owner = "odps";
        model.group = "odps";
        model.quota = -1L;
        model.permission = DEFAULT_DIRECTORY_PERMISSION;
        model.accessTime = new Date(0L);
        model.creationTime = new Date(0L);
        model.modificationTime = new Date(0L);
        model.symlink = "";
        VolumeFSFile rootPath = new VolumeFSFile(model, project, "/", client);
        return rootPath;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildVolumeResource(this.project, this.getVolume());
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        params.put("meta", null);
        headers.put("x-odps-volume-fs-path", this.path);
        Response resp = this.client.request(resource, Request.Method.GET.name(), params, headers, null);
        try {
            this.model = JAXBUtils.unmarshal(resp, VolumeFSFileModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException("Can't bind xml to " + VolumeFSFileModel.class, e);
        }
        this.setLoaded(true);
    }

    public static VolumeFSFile create(String project, String path, boolean isDir, RestClient client) throws VolumeException {
        VolumeFSFile.checkVolume(path);
        if (!isDir) {
            throw new VolumeException("NotAcceptableOperation", "Not Support to create file yet!");
        }
        FileForCreate file = new FileForCreate();
        file.setPath(path);
        file.setType(isDir ? ItemType.DIRECTORY.name().toLowerCase() : ItemType.FILE.name().toLowerCase());
        String xml = null;
        try {
            xml = JAXBUtils.marshal(file, FileForCreate.class);
        }
        catch (JAXBException e) {
            throw new VolumeException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ResourceBuilder.buildVolumeResource(project, VolumeFSFile.getVolume(path));
        try {
            client.stringRequest(resource, Request.Method.POST.name(), null, headers, xml);
        }
        catch (OdpsException e) {
            throw new VolumeException(e);
        }
        return new VolumeFSFile(project, path, client);
    }

    public void delete(boolean recursive) throws VolumeException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        params.put(ParamKey.RECURSIVE.name().toLowerCase(), String.valueOf(recursive));
        headers.put("x-odps-volume-fs-path", this.path);
        String resource = ResourceBuilder.buildVolumeResource(this.project, this.getVolume());
        try {
            this.client.request(resource, Request.Method.DELETE.name(), params, headers, null);
        }
        catch (OdpsException e) {
            throw new VolumeException(e);
        }
    }

    public VolumeFSFile update(Map<String, String> param2) throws VolumeException {
        String src = this.getPath();
        FileForUpdate file = new FileForUpdate();
        String path = param2.get(ParamKey.PATH.name().toLowerCase());
        String replication = param2.get(ParamKey.REPLICATION.name().toLowerCase());
        if (path != null) {
            file.setPath(path);
        }
        if (replication != null) {
            file.setReplication(replication);
        }
        String xml = null;
        try {
            xml = JAXBUtils.marshal(file, FileForUpdate.class);
        }
        catch (JAXBException e) {
            throw new VolumeException(e.getMessage(), e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        params.put("meta", null);
        headers.put("Content-Type", "application/xml");
        headers.put("x-odps-volume-fs-path", src);
        String resource = ResourceBuilder.buildVolumeResource(this.project, VolumeFSFile.getVolume(src));
        try {
            this.client.stringRequest(resource, Request.Method.PUT.name(), params, headers, xml);
        }
        catch (OdpsException e) {
            throw new VolumeException(e);
        }
        this.model = null;
        this.setLoaded(false);
        if (path != null) {
            this.path = path;
        }
        return this;
    }

    @Override
    public Iterator<VolumeFSFile> iterator() {
        return new ListIterator<VolumeFSFile>(){
            Map<String, String> params = new HashMap<String, String>();
            Map<String, String> headers = new HashMap<String, String>();

            @Override
            protected List<VolumeFSFile> list() {
                ArrayList<VolumeFSFile> files = new ArrayList<VolumeFSFile>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get(ParamKey.MARKER.name().toLowerCase());
                if (this.params.containsKey(ParamKey.MARKER.name().toLowerCase()) && lastMarker.length() == 0) {
                    return null;
                }
                String resource = ResourceBuilder.buildVolumeResource(VolumeFSFile.this.project, VolumeFSFile.this.getVolume());
                this.headers.put("x-odps-volume-fs-path", VolumeFSFile.this.path);
                try {
                    VolumeFSList list = VolumeFSFile.this.client.request(VolumeFSList.class, resource, Request.Method.GET.name(), this.params, this.headers, null);
                    for (VolumeFSFileModel model : list.files) {
                        VolumeFSFile file = new VolumeFSFile(model, VolumeFSFile.this.project, model.getPath(), VolumeFSFile.this.client);
                        files.add(file);
                    }
                    this.params.put(ParamKey.MARKER.name().toLowerCase(), list.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), new VolumeException(e));
                }
                return files;
            }
        };
    }

    public String getProject() {
        return this.project;
    }

    public String getVolume() {
        return VolumeFSFile.getVolume(this.path);
    }

    public static String getVolume(String path) {
        String[] array = path.split("/");
        if (array.length < 2) {
            return null;
        }
        return array[1];
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getIsdir() {
        if (this.model == null || this.model.isdir == null) {
            this.lazyLoad();
        }
        return this.model.isdir;
    }

    public String getPermission() {
        if (this.model == null || this.model.permission == null) {
            this.lazyLoad();
        }
        return this.model.permission;
    }

    public Integer getBlockReplications() {
        if (this.model == null || this.model.blockReplications == null) {
            this.lazyLoad();
        }
        return this.model.blockReplications;
    }

    public Long getLength() {
        if (this.model == null || this.model.length == null) {
            this.lazyLoad();
        }
        return this.model.length;
    }

    public Long getQuota() {
        if (this.model == null || this.model.quota == null) {
            this.lazyLoad();
        }
        return this.model.quota;
    }

    public Long getBlockSize() {
        if (this.model == null || this.model.blockSize == null) {
            this.lazyLoad();
        }
        return this.model.blockSize;
    }

    public String getOwner() {
        if (this.model == null || this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public String getGroup() {
        if (this.model == null || this.model.group == null) {
            this.lazyLoad();
        }
        return this.model.group;
    }

    public Date getCreationTime() {
        if (this.model == null || this.model.creationTime == null) {
            this.lazyLoad();
        }
        return this.model.creationTime;
    }

    public Date getAccessTime() {
        if (this.model == null || this.model.accessTime == null) {
            this.lazyLoad();
        }
        return this.model.accessTime;
    }

    public Date getModificationTime() {
        if (this.model == null || this.model.modificationTime == null) {
            this.lazyLoad();
        }
        return this.model.modificationTime;
    }

    public String getSymlink() {
        if (this.model == null || this.model.symlink == null) {
            this.lazyLoad();
        }
        return this.model.symlink;
    }

    private static void checkVolume(String path) throws VolumeException {
        if (!Volume.checkPathHasVolume(path)) {
            throw new VolumeException("VolumeMissing", "missing volume in path: " + path + "!");
        }
    }

    public static VolumeFSFile transferVolumeToVolumeFSFile(String project, Volume volume, RestClient client) {
        VolumeFSFileModel model = new VolumeFSFileModel();
        model.project = project;
        model.volume = volume.getName();
        model.isdir = true;
        model.blockSize = 0L;
        model.blockReplications = 0;
        model.length = 0L;
        model.owner = "odps";
        model.group = "odps";
        model.quota = -1L;
        model.permission = DEFAULT_DIRECTORY_PERMISSION;
        model.accessTime = new Date(0L);
        model.creationTime = volume.getCreatedTime();
        model.modificationTime = volume.getLastModifiedTime();
        model.symlink = "";
        VolumeFSFile volumeFSFile = new VolumeFSFile(model, project, "/" + volume.getName(), client);
        return volumeFSFile;
    }

    @XmlRootElement(name="Item")
    private static class FileForUpdate {
        @XmlElement(name="Path")
        private String path;
        @XmlElement(name="Replication")
        private String replication;

        private FileForUpdate() {
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setReplication(String replication) {
            this.replication = replication;
        }
    }

    @XmlRootElement(name="Item")
    private static class FileForCreate {
        @XmlElement(name="Type")
        private String type;
        @XmlElement(name="Path")
        private String path;

        private FileForCreate() {
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    @XmlRootElement(name="Items")
    private static class VolumeFSList {
        @XmlElement(name="Item")
        private List<VolumeFSFileModel> files = new ArrayList<VolumeFSFileModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private VolumeFSList() {
        }
    }

    @XmlRootElement(name="Item")
    static class VolumeFSFileModel {
        @XmlElement(name="Project")
        String project;
        @XmlElement(name="Volume")
        String volume;
        @XmlElement(name="Path")
        String path;
        @XmlElement(name="Isdir")
        Boolean isdir;
        @XmlElement(name="Permission")
        String permission;
        @XmlElement(name="BlockReplications")
        Integer blockReplications;
        @XmlElement(name="Length")
        Long length;
        @XmlElement(name="Quota")
        Long quota;
        @XmlElement(name="BlockSize")
        Long blockSize;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="Group")
        String group;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date creationTime;
        @XmlElement(name="AccessTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date accessTime;
        @XmlElement(name="ModificationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date modificationTime;
        @XmlElement(name="Symlink")
        String symlink;

        VolumeFSFileModel() {
        }

        public String getPath() {
            return this.path;
        }
    }

    public static enum ParamKey {
        PATH,
        REPLICATION,
        RECURSIVE,
        MARKER;

    }

    public static enum ItemType {
        FILE,
        DIRECTORY;

    }
}

