/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ByteWritable
implements WritableComparable<ByteWritable> {
    private byte value;

    public ByteWritable() {
    }

    public ByteWritable(byte value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((ByteWritable)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    @Override
    public int compareTo(ByteWritable o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }

    public byte get() {
        return this.value;
    }

    public void set(byte value) {
        this.value = value;
    }

    static {
        WritableComparator.define(ByteWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ByteWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            byte thatValue;
            byte thisValue = Comparator.readByte(b1, s1);
            return thisValue < (thatValue = Comparator.readByte(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

