/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ml;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.ml.ModelResourceBuilder;
import com.aliyun.odps.ml.OnlineModel;
import com.aliyun.odps.ml.OnlineModelFilter;
import com.aliyun.odps.ml.OnlineModelInfo;
import com.aliyun.odps.ml.OnlineModelInfoNew;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class OnlineModels
implements Iterable<OnlineModel> {
    private RestClient client;

    public OnlineModels(RestClient client) {
        this.client = client;
    }

    public OnlineModel get(String modelName) {
        return this.get(this.getDefaultProjectName(), modelName);
    }

    public OnlineModel get(String projectName, String modelName) {
        OnlineModel.OnlineModelDesc desc = new OnlineModel.OnlineModelDesc();
        desc.project = projectName;
        desc.modelName = modelName;
        return new OnlineModel(desc, this.client);
    }

    public boolean exists(String modelName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), modelName);
    }

    public boolean exists(String projectName, String modelName) throws OdpsException {
        try {
            OnlineModel m3 = this.get(projectName, modelName);
            m3.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<OnlineModel> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<OnlineModel> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    protected Iterator<OnlineModel> iterator(OnlineModelFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    protected Iterator<OnlineModel> iterator(final String projectName, final OnlineModelFilter filter) {
        return new ListIterator<OnlineModel>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<OnlineModel> list() {
                ArrayList<OnlineModel> models = new ArrayList<OnlineModel>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && (lastMarker == null || lastMarker.length() == 0)) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ModelResourceBuilder.buildOnlineModelResource(projectName);
                try {
                    ListOnlineModelsResponse resp = OnlineModels.this.client.request(ListOnlineModelsResponse.class, resource, "GET", this.params);
                    for (OnlineModel.OnlineModelDesc desc : resp.onlineModelDescs) {
                        OnlineModel m3 = new OnlineModel(desc, OnlineModels.this.client);
                        models.add(m3);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return models;
            }
        };
    }

    public OnlineModel create(String modelName, String offlinemodelProject, String offlinemodelName, short qos) throws OdpsException {
        return this.createInternally(this.getDefaultProjectName(), modelName, offlinemodelProject, offlinemodelName, qos, "");
    }

    public OnlineModel create(String modelName, String offlinemodelProject, String offlinemodelName, short qos, String serviceTag) throws OdpsException {
        return this.createInternally(this.getDefaultProjectName(), modelName, offlinemodelProject, offlinemodelName, qos, serviceTag);
    }

    public OnlineModel create(String projectName, String modelName, String offlinemodelProject, String offlinemodelName, short qos) throws OdpsException {
        return this.createInternally(projectName, modelName, offlinemodelProject, offlinemodelName, qos, "");
    }

    public OnlineModel create(String projectName, String modelName, String offlinemodelProject, String offlinemodelName, short qos, String serviceTag) throws OdpsException {
        return this.createInternally(projectName, modelName, offlinemodelProject, offlinemodelName, qos, serviceTag);
    }

    public OnlineModel create(OnlineModelInfo modelInfo) throws OdpsException {
        return this.createInternally(modelInfo);
    }

    public OnlineModel create(OnlineModelInfoNew modelInfo) throws OdpsException {
        return this.createInternally(modelInfo);
    }

    public void delete(String modelName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), modelName);
    }

    public void delete(String projectName, String modelName) throws OdpsException {
        String resource = ModelResourceBuilder.buildOnlineModelResource(projectName, modelName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private OnlineModel createInternally(String projectName, String modelName, String offlinemodelProject, String offlinemodelName, short qos, String serviceTag) throws OdpsException {
        if (projectName == null || projectName.equals("")) {
            throw new IllegalArgumentException("Project required.");
        }
        if (modelName == null || modelName.equals("")) {
            throw new IllegalArgumentException("ModelName required.");
        }
        if (offlinemodelProject == null || offlinemodelProject.equals("")) {
            throw new IllegalArgumentException("OfflinemodelPrject required.");
        }
        if (offlinemodelName == null || offlinemodelName.equals("")) {
            throw new IllegalArgumentException("OfflinemodelName required.");
        }
        OnlineModelInfo modelInfo = new OnlineModelInfo();
        modelInfo.project = projectName;
        modelInfo.modelName = modelName;
        modelInfo.offlineProject = offlinemodelProject;
        modelInfo.offlineModelName = offlinemodelName;
        modelInfo.QOS = qos;
        modelInfo.serviceTag = serviceTag;
        return this.createInternally(modelInfo);
    }

    private OnlineModel createInternally(OnlineModelInfo modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = JAXBUtils.marshal(modelInfo, OnlineModelInfo.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOnlineModelResource(modelInfo.project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        OnlineModel.OnlineModelDesc desc = new OnlineModel.OnlineModelDesc();
        desc.project = modelInfo.project;
        desc.modelName = modelInfo.modelName;
        desc.offlinemodelProject = modelInfo.offlineProject;
        desc.offlinemodelName = modelInfo.offlineModelName;
        desc.applyQos = modelInfo.QOS;
        desc.instanceNum = modelInfo.instanceNum;
        return new OnlineModel(desc, this.client);
    }

    private OnlineModel createInternally(OnlineModelInfoNew modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = JAXBUtils.marshal(modelInfo, OnlineModelInfoNew.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOnlineModelResource(modelInfo.project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        OnlineModel.OnlineModelDesc desc = new OnlineModel.OnlineModelDesc();
        desc.project = modelInfo.project;
        desc.modelName = modelInfo.modelName;
        desc.applyQos = modelInfo.QOS;
        desc.instanceNum = modelInfo.instanceNum;
        return new OnlineModel(desc, this.client);
    }

    @XmlRootElement(name="Onlinemodels")
    private static class ListOnlineModelsResponse {
        @XmlElement(name="Onlinemodel")
        private List<OnlineModel.OnlineModelDesc> onlineModelDescs = new ArrayList<OnlineModel.OnlineModelDesc>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListOnlineModelsResponse() {
        }
    }
}

