/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.google.gson.GsonBuilder;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="CUPID")
public class CupidTask
extends Task {
    private String Plan;

    public String getPlan() {
        return this.Plan;
    }

    @XmlElement(name="Plan")
    public void setPlan(String plan) {
        this.Plan = plan;
    }

    static CupidTask GetCupidTask(String plan, String taskName, Map<String, String> hints) throws OdpsException {
        CupidTask task = new CupidTask();
        task.setName(taskName);
        task.setPlan(plan);
        task.setProperty("type", "cupid");
        if (hints != null) {
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return task;
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints, int priority) throws OdpsException {
        CupidTask task = CupidTask.GetCupidTask(plan, "cupid_task", hints);
        return odps.instances().create(project, task, priority);
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints) throws OdpsException {
        CupidTask task = CupidTask.GetCupidTask(plan, "cupid_task", hints);
        return odps.instances().create(project, task);
    }
}

