/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.Instance;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;

public class GsonObjectBuilder {
    private GsonObjectBuilder() {
    }

    public static Gson get() {
        return GsonHolder.GSON_INSTANCE;
    }

    private static class GsonHolder {
        private static final GsonObjectAdapter ADAPTER = new GsonObjectAdapter();
        private static final TaskSummaryAdapter TS_ADAPTER = new TaskSummaryAdapter();
        private static final Gson GSON_INSTANCE = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Map.class), ADAPTER).registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), ADAPTER).registerTypeAdapter(new TypeToken<Map<Object, Object>>(){}.getType(), ADAPTER).registerTypeAdapter((Type)((Object)Instance.TaskSummary.class), TS_ADAPTER).create();

        private GsonHolder() {
        }
    }

    public static class TaskSummaryAdapter
    extends TypeAdapter<Object> {
        private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

        @Override
        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        list.add(this.read(in));
                    }
                    in.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    Instance.TaskSummary ts = new Instance.TaskSummary();
                    in.beginObject();
                    while (in.hasNext()) {
                        ts.put(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return ts;
                }
                case STRING: {
                    return in.nextString();
                }
                case NUMBER: {
                    String inStr = in.nextString();
                    if (inStr.contains(".") || inStr.contains("e") || inStr.contains("E")) {
                        return Double.parseDouble(inStr);
                    }
                    BigInteger num = new BigInteger(inStr);
                    BigInteger longMax = new BigInteger(String.valueOf(Long.MAX_VALUE));
                    BigInteger longMin = new BigInteger(String.valueOf(Long.MIN_VALUE));
                    if (num.compareTo(longMax) > 0 || num.compareTo(longMin) < 0) {
                        return num;
                    }
                    return Long.parseLong(inStr);
                }
                case BOOLEAN: {
                    return in.nextBoolean();
                }
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void write(JsonWriter out, Object value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            this.delegate.write(out, value);
        }
    }

    public static class GsonObjectAdapter
    extends TypeAdapter<Object> {
        private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

        @Override
        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        list.add(this.read(in));
                    }
                    in.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    LinkedTreeMap<String, Object> map = new LinkedTreeMap<String, Object>();
                    in.beginObject();
                    while (in.hasNext()) {
                        map.put(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return map;
                }
                case STRING: {
                    return in.nextString();
                }
                case NUMBER: {
                    String inStr = in.nextString();
                    if (inStr.contains(".") || inStr.contains("e") || inStr.contains("E")) {
                        return Double.parseDouble(inStr);
                    }
                    BigInteger num = new BigInteger(inStr);
                    BigInteger longMax = new BigInteger(String.valueOf(Long.MAX_VALUE));
                    BigInteger longMin = new BigInteger(String.valueOf(Long.MIN_VALUE));
                    if (num.compareTo(longMax) > 0 || num.compareTo(longMin) < 0) {
                        return num;
                    }
                    return Long.parseLong(inStr);
                }
                case BOOLEAN: {
                    return in.nextBoolean();
                }
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void write(JsonWriter out, Object value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            this.delegate.write(out, value);
        }
    }
}

