/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.catalog;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Projects;
import com.aliyun.odps.Tables;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.maxcompute.config.MaxcomputeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxComputeCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(MaxComputeCatalog.class);
    private final ReadonlyConfig readonlyConfig;
    private final String catalogName;
    private Account account;

    public MaxComputeCatalog(String catalogName, ReadonlyConfig options) {
        this.readonlyConfig = options;
        this.catalogName = catalogName;
    }

    public void open() throws CatalogException {
        this.account = new AliyunAccount((String)this.readonlyConfig.get(MaxcomputeConfig.ACCESS_ID), (String)this.readonlyConfig.get(MaxcomputeConfig.ACCESS_KEY));
    }

    public void close() throws CatalogException {
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() throws CatalogException {
        return (String)this.readonlyConfig.get(MaxcomputeConfig.PROJECT);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Odps odps = new Odps(this.account);
        odps.setEndpoint((String)this.readonlyConfig.get(MaxcomputeConfig.ENDPOINT));
        odps.setDefaultProject((String)this.readonlyConfig.get(MaxcomputeConfig.PROJECT));
        Projects projects = odps.projects();
        try {
            return projects.exists(databaseName);
        }
        catch (OdpsException e) {
            throw new CatalogException("Check " + databaseName + " exist error", (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            String project = (String)this.readonlyConfig.get(MaxcomputeConfig.PROJECT);
            if (this.databaseExists(project)) {
                return Lists.newArrayList(project);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new CatalogException("listDatabases exist error", (Throwable)e);
        }
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        Odps odps = new Odps(this.account);
        odps.setEndpoint((String)this.readonlyConfig.get(MaxcomputeConfig.ENDPOINT));
        odps.setDefaultProject(databaseName);
        Tables tables = odps.tables();
        ArrayList<String> tableNames = new ArrayList<String>();
        tables.forEach(table -> tableNames.add(table.getName()));
        return tableNames;
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        Odps odps = new Odps(this.account);
        odps.setEndpoint((String)this.readonlyConfig.get(MaxcomputeConfig.ENDPOINT));
        odps.setDefaultProject(tablePath.getDatabaseName());
        Tables tables = odps.tables();
        try {
            return tables.exists(tablePath.getTableName());
        }
        catch (OdpsException e) {
            throw new CatalogException("tableExists" + tablePath + " error", (Throwable)e);
        }
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        throw new UnsupportedOperationException();
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }
}

