/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.maxcompute.catalog;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;

@AutoService(value={DataTypeConvertor.class})
public class MaxComputeDataTypeConvertor
implements DataTypeConvertor<TypeInfo> {
    public SeaTunnelDataType<?> toSeaTunnelType(String field2, String connectorDataType) {
        if (connectorDataType.startsWith("MAP")) {
            int i = connectorDataType.indexOf(",");
            return new MapType(this.toSeaTunnelType(field2, connectorDataType.substring(4, i)), this.toSeaTunnelType(field2, connectorDataType.substring(i + 1, connectorDataType.length() - 1)));
        }
        if (connectorDataType.startsWith("ARRAY")) {
            SeaTunnelDataType<?> seaTunnelType = this.toSeaTunnelType(field2, connectorDataType.substring(6, connectorDataType.length() - 1));
            switch (seaTunnelType.getSqlType()) {
                case STRING: {
                    return ArrayType.STRING_ARRAY_TYPE;
                }
                case BOOLEAN: {
                    return ArrayType.BOOLEAN_ARRAY_TYPE;
                }
                case BYTES: {
                    return ArrayType.BYTE_ARRAY_TYPE;
                }
                case SMALLINT: {
                    return ArrayType.SHORT_ARRAY_TYPE;
                }
                case INT: {
                    return ArrayType.INT_ARRAY_TYPE;
                }
                case BIGINT: {
                    return ArrayType.LONG_ARRAY_TYPE;
                }
                case FLOAT: {
                    return ArrayType.FLOAT_ARRAY_TYPE;
                }
                case DOUBLE: {
                    return ArrayType.DOUBLE_ARRAY_TYPE;
                }
            }
            throw CommonError.convertToSeaTunnelTypeError("Maxcompute", connectorDataType, field2);
        }
        if (connectorDataType.startsWith("STRUCT")) {
            String substring = connectorDataType.substring(7, connectorDataType.length() - 1);
            String[] entryArray = substring.split(",");
            String[] fieldNames = new String[entryArray.length];
            SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                String[] fieldNameAndType = entryArray[i].split(":");
                fieldNames[i] = fieldNameAndType[0];
                fieldTypes[i] = this.toSeaTunnelType(fieldNameAndType[0], fieldNameAndType[1]);
            }
            return new SeaTunnelRowType(fieldNames, fieldTypes);
        }
        if (connectorDataType.startsWith("DECIMAL")) {
            if (connectorDataType.contains("(")) {
                String substring = connectorDataType.substring(8, connectorDataType.length() - 1);
                String[] split = substring.split(",");
                return new DecimalType(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
            }
            return new DecimalType(54, 18);
        }
        if (connectorDataType.startsWith("CHAR") || connectorDataType.startsWith("VARCHAR")) {
            return BasicType.STRING_TYPE;
        }
        switch (connectorDataType) {
            case "TINYINT": 
            case "BINARY": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "STRING": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "BOOLEAN": {
                return DecimalType.BOOLEAN_TYPE;
            }
            case "NULL": {
                return BasicType.VOID_TYPE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError("Maxcompute", connectorDataType, field2);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field2, TypeInfo connectorDataType, Map<String, Object> dataTypeProperties) {
        switch (connectorDataType.getOdpsType()) {
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)connectorDataType;
                return new MapType(this.toSeaTunnelType(field2, mapTypeInfo.getKeyTypeInfo(), dataTypeProperties), this.toSeaTunnelType(field2, mapTypeInfo.getValueTypeInfo(), dataTypeProperties));
            }
            case ARRAY: {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)connectorDataType;
                switch (arrayTypeInfo.getElementTypeInfo().getOdpsType()) {
                    case BOOLEAN: {
                        return ArrayType.BOOLEAN_ARRAY_TYPE;
                    }
                    case INT: {
                        return ArrayType.INT_ARRAY_TYPE;
                    }
                    case BIGINT: {
                        return ArrayType.LONG_ARRAY_TYPE;
                    }
                    case FLOAT: {
                        return ArrayType.FLOAT_ARRAY_TYPE;
                    }
                    case DOUBLE: {
                        return ArrayType.DOUBLE_ARRAY_TYPE;
                    }
                    case STRING: {
                        return ArrayType.STRING_ARRAY_TYPE;
                    }
                }
                throw CommonError.convertToSeaTunnelTypeError("Maxcompute", connectorDataType.getTypeName(), field2);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)connectorDataType;
                List<TypeInfo> fields = structTypeInfo.getFieldTypeInfos();
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                ArrayList fieldTypes = new ArrayList(fields.size());
                for (TypeInfo f : fields) {
                    fieldNames.add(f.getTypeName());
                    fieldTypes.add(this.toSeaTunnelType(f.getTypeName(), f, dataTypeProperties));
                }
                return new SeaTunnelRowType(fieldNames.toArray(new String[0]), fieldTypes.toArray(new SeaTunnelDataType[0]));
            }
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case INT: {
                return BasicType.INT_TYPE;
            }
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case BINARY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)connectorDataType;
                return new DecimalType(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return BasicType.STRING_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case DATETIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case VOID: {
                return BasicType.VOID_TYPE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError("Maxcompute", connectorDataType.getTypeName(), field2);
    }

    public TypeInfo toConnectorType(String field2, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        switch (seaTunnelDataType.getSqlType()) {
            case MAP: {
                MapType mapType = (MapType)seaTunnelDataType;
                return TypeInfoFactory.getMapTypeInfo((TypeInfo)this.toConnectorType(field2, mapType.getKeyType(), (Map)dataTypeProperties), (TypeInfo)this.toConnectorType(field2, mapType.getValueType(), (Map)dataTypeProperties));
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)seaTunnelDataType;
                return TypeInfoFactory.getArrayTypeInfo((TypeInfo)this.toConnectorType(field2, arrayType.getElementType(), (Map)dataTypeProperties));
            }
            case ROW: {
                SeaTunnelRowType rowType = (SeaTunnelRowType)seaTunnelDataType;
                ArrayList<String> fieldNames = new ArrayList<String>(rowType.getTotalFields());
                ArrayList<TypeInfo> fieldTypes = new ArrayList<TypeInfo>(rowType.getTotalFields());
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    fieldNames.add(rowType.getFieldName(i));
                    fieldTypes.add((TypeInfo)this.toConnectorType(field2, rowType.getFieldType(i), (Map)dataTypeProperties));
                }
                return TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypes);
            }
            case TINYINT: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.TINYINT);
            }
            case SMALLINT: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.SMALLINT);
            }
            case INT: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.INT);
            }
            case BIGINT: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.BIGINT);
            }
            case BYTES: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.BINARY);
            }
            case FLOAT: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.FLOAT);
            }
            case DOUBLE: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.DOUBLE);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)seaTunnelDataType;
                return TypeInfoFactory.getDecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
            }
            case STRING: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.STRING);
            }
            case DATE: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.DATE);
            }
            case TIMESTAMP: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.TIMESTAMP);
            }
            case TIME: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.DATETIME);
            }
            case BOOLEAN: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.BOOLEAN);
            }
            case NULL: {
                return TypeInfoFactory.getPrimitiveTypeInfo(OdpsType.VOID);
            }
        }
        throw CommonError.convertToConnectorTypeError("Maxcompute", seaTunnelDataType.getSqlType().toString(), field2);
    }

    public String getIdentity() {
        return "Maxcompute";
    }
}

