/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.sink;

import com.mongodb.MongoException;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.mongodb.exception.MongodbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbCollectionProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.DocumentSerializer;
import org.apache.seatunnel.connectors.seatunnel.mongodb.sink.MongodbWriterOptions;
import org.apache.seatunnel.connectors.seatunnel.mongodb.sink.state.DocumentBulk;
import org.apache.seatunnel.connectors.seatunnel.mongodb.sink.state.MongodbCommitInfo;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbWriter
implements SinkWriter<SeaTunnelRow, MongodbCommitInfo, DocumentBulk> {
    private static final Logger log = LoggerFactory.getLogger(MongodbWriter.class);
    private MongodbClientProvider collectionProvider;
    private final DocumentSerializer<SeaTunnelRow> serializer;
    private long bulkActions;
    private final List<WriteModel<BsonDocument>> bulkRequests;
    private int maxRetries;
    private long retryIntervalMs;
    private long batchIntervalMs;
    private volatile long lastSendTime = 0L;
    private boolean transaction;
    private final SinkWriter.Context context;

    public MongodbWriter(DocumentSerializer<SeaTunnelRow> serializer, MongodbWriterOptions options, SinkWriter.Context context) {
        this.initOptions(options);
        this.context = context;
        this.serializer = serializer;
        this.bulkRequests = new ArrayList<WriteModel<BsonDocument>>();
    }

    private void initOptions(MongodbWriterOptions options) {
        this.maxRetries = options.getRetryMax();
        this.retryIntervalMs = options.getRetryInterval();
        this.collectionProvider = MongodbCollectionProvider.builder().connectionString(options.getConnectString()).database(options.getDatabase()).collection(options.getCollection()).build();
        this.bulkActions = options.getFlushSize();
        this.batchIntervalMs = options.getBatchIntervalMs();
        this.transaction = options.transaction;
    }

    public void write(SeaTunnelRow o) {
        if (o.getRowKind() != RowKind.UPDATE_BEFORE) {
            this.bulkRequests.add(this.serializer.serializeToWriteModel(o));
            if (!this.transaction && (this.isOverMaxBatchSizeLimit() || this.isOverMaxBatchIntervalLimit())) {
                this.doBulkWrite();
            }
        }
    }

    public Optional<MongodbCommitInfo> prepareCommit() {
        if (!this.transaction) {
            this.doBulkWrite();
            return Optional.empty();
        }
        ArrayList<DocumentBulk> bsonDocuments = new ArrayList<DocumentBulk>();
        AtomicInteger counter = new AtomicInteger();
        this.bulkRequests.stream().map(this::convertModelToBsonDocument).collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 1024)).values().stream().map(this::convertBsonDocumentListToDocumentBulk).forEach(bsonDocuments::add);
        this.bulkRequests.clear();
        return Optional.of(new MongodbCommitInfo(bsonDocuments));
    }

    private BsonDocument convertModelToBsonDocument(WriteModel<BsonDocument> model) {
        if (model instanceof InsertOneModel) {
            return (BsonDocument)((InsertOneModel)model).getDocument();
        }
        if (model instanceof UpdateOneModel) {
            return (BsonDocument)((UpdateOneModel)model).getUpdate();
        }
        return null;
    }

    private DocumentBulk convertBsonDocumentListToDocumentBulk(List<BsonDocument> documentList) {
        DocumentBulk documentBulk = new DocumentBulk();
        documentList.forEach(documentBulk::add);
        return documentBulk;
    }

    public void abortPrepare() {
    }

    public void close() {
        if (!this.transaction) {
            this.doBulkWrite();
        }
        if (this.collectionProvider != null) {
            this.collectionProvider.close();
        }
    }

    synchronized void doBulkWrite() {
        if (this.bulkRequests.isEmpty()) {
            return;
        }
        boolean success = IntStream.rangeClosed(0, this.maxRetries).anyMatch(i -> {
            try {
                this.lastSendTime = System.currentTimeMillis();
                this.collectionProvider.getDefaultCollection().bulkWrite(this.bulkRequests, new BulkWriteOptions().ordered(true));
                this.bulkRequests.clear();
                return true;
            }
            catch (MongoException e) {
                log.debug("Bulk Write to MongoDB failed, retry times = {}", (Object)i, (Object)e);
                if (i >= this.maxRetries) {
                    throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "Bulk Write to MongoDB failed", e);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalMs * (long)(i + 1));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "Unable to flush; interrupted while doing another attempt", e);
                }
                return false;
            }
        });
        if (!success) {
            throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "Bulk Write to MongoDB failed after max retries");
        }
    }

    private boolean isOverMaxBatchSizeLimit() {
        return this.bulkActions != -1L && (long)this.bulkRequests.size() >= this.bulkActions;
    }

    private boolean isOverMaxBatchIntervalLimit() {
        long lastSentInterval = System.currentTimeMillis() - this.lastSendTime;
        return this.batchIntervalMs != -1L && lastSentInterval >= this.batchIntervalMs;
    }
}

