/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.sink.commit;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.connectors.seatunnel.mongodb.sink.commit.CommittableTransaction;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class CommittableUpsertTransaction
extends CommittableTransaction {
    private final String[] upsertKeys;
    private final UpdateOptions updateOptions = new UpdateOptions();
    private final BulkWriteOptions bulkWriteOptions = new BulkWriteOptions();

    public CommittableUpsertTransaction(MongoCollection<BsonDocument> collection, List<BsonDocument> documents, String[] upsertKeys) {
        super(collection, documents);
        this.upsertKeys = upsertKeys;
        this.updateOptions.upsert(true);
        this.bulkWriteOptions.ordered(true);
    }

    @Override
    public Integer execute() {
        ArrayList upserts = new ArrayList();
        for (BsonDocument document : this.bufferedDocuments) {
            ArrayList<Bson> filters = new ArrayList<Bson>(this.upsertKeys.length);
            for (String upsertKey : this.upsertKeys) {
                BsonValue o = document.get("$set").asDocument().get(upsertKey);
                Bson eq = Filters.eq(upsertKey, o);
                filters.add(eq);
            }
            Bson filter = Filters.and(filters);
            UpdateOneModel updateOneModel = new UpdateOneModel(filter, document, this.updateOptions);
            upserts.add(updateOneModel);
        }
        BulkWriteResult bulkWriteResult = this.collection.bulkWrite(upserts, this.bulkWriteOptions);
        return bulkWriteResult.getUpserts().size() + bulkWriteResult.getInsertedCount();
    }
}

