/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.sink;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.SerializableFunction;
import org.apache.seatunnel.connectors.seatunnel.mongodb.sink.MongodbWriterOptions;
import org.bson.BsonDocument;

public class MongoKeyExtractor
implements SerializableFunction<BsonDocument, BsonDocument> {
    private static final long serialVersionUID = 1L;
    private final String[] upsertKey;

    public MongoKeyExtractor(MongodbWriterOptions options) {
        this.upsertKey = options.getUpsertKey();
    }

    @Override
    public BsonDocument apply(BsonDocument bsonDocument) {
        return Arrays.stream(this.upsertKey).filter(bsonDocument::containsKey).collect(Collectors.toMap(key -> key, bsonDocument::get, (v1, v2) -> v1, BsonDocument::new));
    }
}

