/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.connectors.seatunnel.mongodb.config.MongodbConfig;

public class MongodbReadOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int fetchSize;
    private final boolean noCursorTimeout;
    private final long maxTimeMS;

    private MongodbReadOptions(int fetchSize, boolean noCursorTimeout, long maxTimeMS) {
        this.fetchSize = fetchSize;
        this.noCursorTimeout = noCursorTimeout;
        this.maxTimeMS = maxTimeMS;
    }

    public static MongoReadOptionsBuilder builder() {
        return new MongoReadOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodbReadOptions)) {
            return false;
        }
        MongodbReadOptions other = (MongodbReadOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        if (this.isNoCursorTimeout() != other.isNoCursorTimeout()) {
            return false;
        }
        return this.getMaxTimeMS() == other.getMaxTimeMS();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongodbReadOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFetchSize();
        result = result * 59 + (this.isNoCursorTimeout() ? 79 : 97);
        long $maxTimeMS = this.getMaxTimeMS();
        result = result * 59 + (int)($maxTimeMS >>> 32 ^ $maxTimeMS);
        return result;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    public static class MongoReadOptionsBuilder {
        private int fetchSize = (Integer)MongodbConfig.FETCH_SIZE.defaultValue();
        private boolean noCursorTimeout = (Boolean)MongodbConfig.CURSOR_NO_TIMEOUT.defaultValue();
        private long maxTimeMin = (Long)MongodbConfig.MAX_TIME_MIN.defaultValue();

        private MongoReadOptionsBuilder() {
        }

        public MongoReadOptionsBuilder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"The fetch size must be larger than 0.");
            this.fetchSize = fetchSize;
            return this;
        }

        public MongoReadOptionsBuilder setNoCursorTimeout(boolean noCursorTimeout) {
            this.noCursorTimeout = noCursorTimeout;
            return this;
        }

        public MongoReadOptionsBuilder setMaxTimeMS(long maxTimeMS) {
            this.maxTimeMin = maxTimeMS;
            return this;
        }

        public MongodbReadOptions build() {
            return new MongodbReadOptions(this.fetchSize, this.noCursorTimeout, this.maxTimeMin);
        }
    }
}

