/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source.reader;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.DocumentDeserializer;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.config.MongodbReadOptions;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplit;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbReader
implements SourceReader<SeaTunnelRow, MongoSplit> {
    private static final Logger log = LoggerFactory.getLogger(MongodbReader.class);
    private final Queue<MongoSplit> pendingSplits;
    private final DocumentDeserializer<SeaTunnelRow> deserializer;
    private final SourceReader.Context context;
    private final MongodbClientProvider clientProvider;
    private MongoCursor<BsonDocument> cursor;
    private final MongodbReadOptions readOptions;
    private volatile boolean noMoreSplit;

    public MongodbReader(SourceReader.Context context, MongodbClientProvider clientProvider, DocumentDeserializer<SeaTunnelRow> deserializer, MongodbReadOptions mongodbReadOptions) {
        this.deserializer = deserializer;
        this.context = context;
        this.clientProvider = clientProvider;
        this.pendingSplits = new ConcurrentLinkedDeque<MongoSplit>();
        this.readOptions = mongodbReadOptions;
    }

    public void open() throws Exception {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public void close() throws IOException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            MongoSplit currentSplit = this.pendingSplits.poll();
            if (null != currentSplit) {
                if (this.cursor != null) {
                    return;
                }
                log.info("Prepared to read split {}", (Object)currentSplit.splitId());
                FindIterable rs = this.clientProvider.getDefaultCollection().find(currentSplit.getQuery()).projection(currentSplit.getProjection()).batchSize(this.readOptions.getFetchSize()).noCursorTimeout(this.readOptions.isNoCursorTimeout()).maxTime(this.readOptions.getMaxTimeMS(), TimeUnit.MINUTES);
                this.cursor = rs.iterator();
                while (this.cursor.hasNext()) {
                    SeaTunnelRow deserialize = this.deserializer.deserialize(this.cursor.next());
                    output.collect((Object)deserialize);
                }
                this.closeCurrentSplit();
            }
            if (this.noMoreSplit && this.pendingSplits.isEmpty()) {
                log.info("Closed the bounded mongodb source");
                this.context.signalNoMoreElement();
            }
        }
    }

    public List<MongoSplit> snapshotState(long checkpointId) throws Exception {
        return new ArrayList<MongoSplit>(this.pendingSplits);
    }

    public void addSplits(List<MongoSplit> splits) {
        log.info("Adding split(s) to reader: {}", splits);
        this.pendingSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        log.info("receive no more splits message, this reader will not add new split.");
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    private void closeCurrentSplit() {
        Preconditions.checkNotNull(this.cursor);
        this.cursor.close();
        this.cursor = null;
    }
}

