/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSourceQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.source.Neo4jSourceReader;

public class Neo4jSource
extends AbstractSingleSplitSource<SeaTunnelRow>
implements SupportColumnProjection {
    private final CatalogTable catalogTable;
    private final Neo4jSourceQueryInfo neo4jSourceQueryInfo;
    private final SeaTunnelRowType rowType;

    public Neo4jSource(CatalogTable catalogTable, Neo4jSourceQueryInfo neo4jSourceQueryInfo) {
        this.catalogTable = catalogTable;
        this.neo4jSourceQueryInfo = neo4jSourceQueryInfo;
        this.rowType = catalogTable.getSeaTunnelRowType();
    }

    public String getPluginName() {
        return "Neo4j";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new Neo4jSourceReader(readerContext, this.neo4jSourceQueryInfo, this.rowType);
    }
}

