/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSourceQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.source.Neo4jSource;

@AutoService(value={Factory.class})
public class Neo4jSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Neo4j";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{Neo4jSourceOptions.KEY_NEO4J_URI, Neo4jSourceOptions.KEY_DATABASE, Neo4jSourceOptions.KEY_QUERY, ConnectorCommonOptions.SCHEMA}).optional(new Option[]{Neo4jSourceOptions.KEY_USERNAME, Neo4jSourceOptions.KEY_PASSWORD, Neo4jSourceOptions.KEY_BEARER_TOKEN, Neo4jSourceOptions.KEY_KERBEROS_TICKET, Neo4jSourceOptions.KEY_MAX_CONNECTION_TIMEOUT, Neo4jSourceOptions.KEY_MAX_TRANSACTION_RETRY_TIME}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return Neo4jSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        Neo4jSourceQueryInfo neo4jSourceQueryInfo = new Neo4jSourceQueryInfo(context.getOptions().toConfig());
        return () -> new Neo4jSource(CatalogTableUtil.buildWithConfig((ReadonlyConfig)context.getOptions()), neo4jSourceQueryInfo);
    }
}

