/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.config;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.neo4j.exception.Neo4jConnectorException;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;

public class DriverBuilder
implements Serializable {
    private final URI uri;
    private String username;
    private String password;
    private String bearerToken;
    private String kerberosTicket;
    private String database;
    private Long maxTransactionRetryTimeSeconds;
    private Long maxConnectionTimeoutSeconds;

    public static DriverBuilder create(URI uri) {
        return new DriverBuilder(uri);
    }

    private DriverBuilder(URI uri) {
        this.uri = uri;
    }

    public Driver build() {
        Config.ConfigBuilder configBuilder = Config.builder().withMaxConnectionPoolSize(1);
        if (this.maxConnectionTimeoutSeconds != null) {
            configBuilder.withConnectionAcquisitionTimeout(this.maxConnectionTimeoutSeconds * 2L, TimeUnit.SECONDS).withConnectionTimeout(this.maxConnectionTimeoutSeconds, TimeUnit.SECONDS);
        }
        if (this.maxTransactionRetryTimeSeconds != null) {
            configBuilder.withMaxTransactionRetryTime(this.maxTransactionRetryTimeSeconds, TimeUnit.SECONDS);
        }
        Config config = configBuilder.build();
        if (this.username != null) {
            return GraphDatabase.driver(this.uri, AuthTokens.basic(this.username, this.password), config);
        }
        if (this.bearerToken != null) {
            return GraphDatabase.driver(this.uri, AuthTokens.bearer(this.bearerToken), config);
        }
        if (this.kerberosTicket != null) {
            return GraphDatabase.driver(this.uri, AuthTokens.kerberos(this.kerberosTicket), config);
        }
        throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "Invalid Field");
    }

    public URI getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public String getKerberosTicket() {
        return this.kerberosTicket;
    }

    public String getDatabase() {
        return this.database;
    }

    public Long getMaxTransactionRetryTimeSeconds() {
        return this.maxTransactionRetryTimeSeconds;
    }

    public Long getMaxConnectionTimeoutSeconds() {
        return this.maxConnectionTimeoutSeconds;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void setKerberosTicket(String kerberosTicket) {
        this.kerberosTicket = kerberosTicket;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setMaxTransactionRetryTimeSeconds(Long maxTransactionRetryTimeSeconds) {
        this.maxTransactionRetryTimeSeconds = maxTransactionRetryTimeSeconds;
    }

    public void setMaxConnectionTimeoutSeconds(Long maxConnectionTimeoutSeconds) {
        this.maxConnectionTimeoutSeconds = maxConnectionTimeoutSeconds;
    }
}

